package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@ApiModel("申请红字信息明细金额相关")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ApplyRedLetterDetailAmount {
    @ApiModelProperty("不含税金额")
    @NotNull(message = "amountWithoutTax参数为必填项")
    private BigDecimal amountWithoutTax;
    @ApiModelProperty("税额")
    @NotNull(message = "taxAmount参数为必填项")
    private BigDecimal taxAmount;
    @ApiModelProperty("税率")
    @NotNull(message = "taxRate参数为必填项")
    private String taxRate;
    @ApiModelProperty("数量")
    private BigDecimal quantity;
    @ApiModelProperty("扣除额")
    private BigDecimal deduction;
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;
}
