package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@ApiModel("申请红字信息发票信息")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ApplyRedLetterHead2 {
    @ApiModelProperty("含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @NotNull(message = "amountWithTax参数为必填项")
    private BigDecimal amountWithTax;

    @ApiModelProperty("不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @NotNull(message = "amountWithoutTax参数为必填项")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @NotNull(message = "taxAmount参数为必填项")
    private BigDecimal taxAmount;

    @ApiModelProperty("税率")
    private String taxRate;

    @ApiModelProperty("申请流水号")
    @NotNull(message = "applySerialNo参数为必填项")
    private String applySerialNo;

    @ApiModelProperty("申请原因")
    private Integer applyReason;

    @ApiModelProperty("成品油类型")
    private Integer oilMemo;

    @ApiModelProperty("购方税号")
    @NotNull(message = "buyerTaxNo参数为必填项")
    private String buyerTaxNo;

    @ApiModelProperty("购方名称")
    @NotNull(message = "buyerName参数为必填项")
    private String buyerName;

    @ApiModelProperty("销方税号")
    @NotNull(message = "sellerTaxNo参数为必填项")
    private String sellerTaxNo;

    @ApiModelProperty("销方名称")
    @NotNull(message = "sellerName参数为必填项")
    private String sellerName;

    @ApiModelProperty("原发票代码")
    @NotNull(message = "originInvoiceCode参数为必填项")
    private String originInvoiceCode;

    @ApiModelProperty("原发票号码")
    @NotNull(message = "originInvoiceNo参数为必填项")
    private String originInvoiceNo;

    @ApiModelProperty("原发票类型")
    @NotNull(message = "originInvoiceType参数为必填项")
    private String originInvoiceType;

    @ApiModelProperty("原开票日期")
    @NotNull(message = "originDateIssued参数为必填项")
    private String originDateIssued;

    @ApiModelProperty("红字明细信息")
    @Valid
    private List<ApplyRedLetterDetail2> details;
}
