package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel("开放接口申请红字信息请求")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OpenApplyRedLetterV2Request {

    @ApiModelProperty("终端唯一码")
    private String terminalUn;

    @ApiModelProperty("设备唯一码")
    @NotNull(message = "deviceUn参数为必填项")
    private String deviceUn;

    @ApiModelProperty("账户类型: AR 或 AP")
    @NotNull(message = "accountType参数为必填项")
    private String accountType;

    @ApiModelProperty("红字信息集合")
    @Valid
    private List<ApplyRedLetterHead2> redLetters;
}
