package com.xforceplus.seller.invoice.client.model.open.v2.invoice;

import com.xforceplus.seller.invoice.client.model.open.v2.pre.BusinessAttrs;
import com.xforceplus.seller.invoice.client.model.open.v2.pre.ExtendedAttrs;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.List;

@Data
@NoArgsConstructor
@ToString
public class IssueSuccessReply {
    @ApiModelProperty("业务单号")
    private String bizOrderNo;
    @ApiModelProperty("业务类型")
    private String customerBizOrderCategory;

    @ApiModelProperty("预制发票id")
    private String preInvoiceId;
    @ApiModelProperty("批次号")
    private String preInvoiceBatchNo;

    @ApiModelProperty("发票代码")
    private String invoiceCode;
    @ApiModelProperty("发票号码")
    private String invoiceNo;

    @ApiModelProperty("发票红蓝标识")
    private String invoiceColor;
    @ApiModelProperty("机器码")
    private String machineCode;

    @ApiModelProperty("开票机号")
    private String diskNo;
    @ApiModelProperty("开票日期")
    private String dateIssued;

    @ApiModelProperty("电子签名")
    private String electronicSignature;
    @ApiModelProperty("校验码")
    private String checkCode;

    @ApiModelProperty("密文")
    private String cipherText;
    @ApiModelProperty("二维码密文")
    private String cipherTextTwoCode;



    @ApiModelProperty("电子签名")
    private String deviceUn;
    @ApiModelProperty("校验码")
    private String terminalUn;

    @ApiModelProperty("密文")
    private String terminalType;
    @ApiModelProperty("系统来源")
    private String source;



    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("计价方式")
    private String pricingMethod;

    @ApiModelProperty("销方编号")
    private String sellerNo;

    @ApiModelProperty("销方名称")
    private String sellerName;

    @ApiModelProperty("销方税号")
    private String sellerTaxNo;

    @ApiModelProperty("销方公司id")
    private String sellerId;
    @ApiModelProperty("销方租户id")
    private String sellerGroupId;

    @ApiModelProperty("销方电话")
    private String sellerTel;

    @ApiModelProperty("销方地址")
    private String sellerAddress;

    @ApiModelProperty("销方银行名称")
    private String sellerBankName;

    @ApiModelProperty("销方银行账号")
    private String sellerBankAccount;



    @ApiModelProperty("购方公司编号")
    private String buyerNo;

    @ApiModelProperty("购方名称")
    private String buyerName;

    @ApiModelProperty("购方税号")
    private String buyerTaxNo;

    @ApiModelProperty("购方公司id")
    private String buyerId;
    @ApiModelProperty("购方租户id")
    private String buyerGroupId;

    @ApiModelProperty("购方电话")
    private String buyerTel;

    @ApiModelProperty("购方地址")
    private String buyerAddress;

    @ApiModelProperty("购方银行名称")
    private String buyerBankName;

    @ApiModelProperty("购方银行名称")
    private String buyerBankAccount;


    @ApiModelProperty("含税金额")
    private String amountWithTax;

    @ApiModelProperty("不含税金额")
    private String amountWithoutTax;

    @ApiModelProperty("税额")
    private String taxAmount;



    @ApiModelProperty("复核人")
    private String reviewer;

    @ApiModelProperty("付款人")
    private String payee;

    @ApiModelProperty("开票人")
    private String issuer;


    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty("原始发票号码")
    private String originInvoiceNo;

    @ApiModelProperty("原始发票代码")
    private String originInvoiceCode;

    @ApiModelProperty("原蓝票开票日期")
    private String originDateIssued;

    @ApiModelProperty("原发票类型")
    private String originInvoiceType;
    @ApiModelProperty("红字信息编号")
    private String redLetterNumber;

    @ApiModelProperty("销货清单文件打印标识")
    private String saleListFileFlag;

    @ApiModelProperty("打印标识（单价和数量）")
    private String printContentFlag;


    @ApiModelProperty("pdf路径")
    private String pdfUrl;

    @ApiModelProperty("ofd路径 ")
    private String ofdUrl;
    @ApiModelProperty("图片路径")
    private String viewUrl;

    @ApiModelProperty("附加信息）")
    private BusinessAttrs businessAttrs;
    @ApiModelProperty("主信息扩展）")
    private ExtendedAttrs extendedAttrs;


    @ApiModelProperty("状态5 待开票")
    private String status;

    @ApiModelProperty("创建时间 ")
    private String createTIme;

    @ApiModelProperty("更新时间")
    private String updateTime;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("更新人")
    private String updateUser;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;

    @ApiModelProperty("发票类型，原来字段invoiceType 即将弃用")
    private String invoiceKind;

    @ApiModelProperty("全电xml")
    private String xmlUrl;



    List<InvoiceDetail> details;
}
