package com.xforceplus.seller.invoice.client.model.open.v2.pre;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel("预制发票明细")
@Data
@NoArgsConstructor
public class PreInvoiceDetail {
    @ApiModelProperty("预制发票id")
    private String preInvoiceId;

    @ApiModelProperty("预制发票明细id")
    private String preInvoiceDetailId;
    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("规格型号")
    private String specifications;
    @ApiModelProperty("数量单位")
    private String unit;

    @ApiModelProperty("数量")
    private String quantity;
    @ApiModelProperty("单价")
    private String unitPrice;
    @ApiModelProperty("税率")
    private String taxRate;


    @ApiModelProperty("含税金额")
    private String amountWithTax;

    @ApiModelProperty("不含税金额")
    private String amountWithoutTax;

    @ApiModelProperty("税额")
    private String taxAmount;

    @ApiModelProperty("扣除额")
    private String deduction;


    @ApiModelProperty("折扣不含税金额")
    private String discountAmountWithoutTax;

    @ApiModelProperty("折扣税额")
    private String discountTaxAmount;

    @ApiModelProperty("折扣含税金额")
    private String discountAmountWithTax;




    @ApiModelProperty("税编版本")
    private String goodsTaxNoVersion;

    @ApiModelProperty("税收分类编码")
    private String goodsTaxNo;
    @ApiModelProperty("批次号")
    private String preInvoiceBatchNo;


    @ApiModelProperty("是否享受税收优惠政策")
    private String taxPre;

    @ApiModelProperty("享受税收优惠政策内容")
    private String taxPreCon;
    @ApiModelProperty("零税率标志")
    private String zeroTax;

    @ApiModelProperty("创建时间 ")
    private String createTIme;

    @ApiModelProperty("更新时间")
    private String updateTime;


    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty("明细扩展")
    private DetailExtendedAttrs detailExtendedAttrs;


}
