package com.xforceplus.seller.invoice.client.model.open.v2.pre;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("预制发票预览")
@Data
@NoArgsConstructor
public class UnIssuedPreinvoice {

    @ApiModelProperty("业务单号")
    private String bizOrderNo;

    @ApiModelProperty("预制发票id")
    private String preInvoiceId;
    @ApiModelProperty("批次号")
    private String preInvoiceBatchNo;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("计价方式")
    private String pricingMethod;

    @ApiModelProperty("销方编号")
    private String sellerNo;

    @ApiModelProperty("销方名称")
    private String sellerName;

    @ApiModelProperty("销方税号")
    private String sellerTaxNo;

    @ApiModelProperty("销方公司id")
    private String sellerId;
    @ApiModelProperty("销方租户id")
    private String sellerGroupId;

    @ApiModelProperty("销方电话")
    private String sellerTel;

    @ApiModelProperty("销方地址")
    private String sellerAddress;

    @ApiModelProperty("销方银行名称")
    private String sellerBankName;

    @ApiModelProperty("销方银行账号")
    private String sellerBankAccount;



    @ApiModelProperty("购方公司编号")
    private String buyerNo;

    @ApiModelProperty("购方名称")
    private String buyerName;

    @ApiModelProperty("购方税号")
    private String buyerTaxNo;

    @ApiModelProperty("购方公司id")
    private String buyerId;
    @ApiModelProperty("购方租户id")
    private String buyerGroupId;

    @ApiModelProperty("购方电话")
    private String buyerTel;

    @ApiModelProperty("购方地址")
    private String buyerAddress;

    @ApiModelProperty("购方银行名称")
    private String buyerBankName;

    @ApiModelProperty("购方银行名称")
    private String buyerBankAccount;


    @ApiModelProperty("含税金额")
    private String amountWithTax;

    @ApiModelProperty("不含税金额")
    private String amountWithoutTax;

    @ApiModelProperty("税额")
    private String taxAmount;



    @ApiModelProperty("复核人")
    private String reviewer;

    @ApiModelProperty("付款人")
    private String payee;

    @ApiModelProperty("开票人")
    private String issuer;


    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty("原始发票号码")
    private String originInvoiceNo;

    @ApiModelProperty("原始发票代码")
    private String originInvoiceCode;

    @ApiModelProperty("原蓝票开票日期")
    private String originDateIssued;

    @ApiModelProperty("原发票类型")
    private String originInvoiceType;
    @ApiModelProperty("红字信息编号")
    private String redLetterNumber;

    @ApiModelProperty("销货清单文件打印标识")
    private String saleListFileFlag;

    @ApiModelProperty("打印标识（单价和数量）")
    private String printContentFlag;

    @ApiModelProperty("附加信息）")
    private BusinessAttrs businessAttrs;
    @ApiModelProperty("主信息扩展）")
    private ExtendedAttrs extendedAttrs;

    @ApiModelProperty("状态5 待开票")
    private String status;

    @ApiModelProperty("创建时间 ")
    private String createTIme;

    @ApiModelProperty("更新时间")
    private String updateTime;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("更新人")
    private String updateUser;


    @ApiModelProperty("备注")
    private List<PreInvoiceDetail> details;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;

    @ApiModelProperty("发票类型，原来字段invoiceType 即将弃用")
    private String invoiceKind;


}
