package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;


@ApiModel(
        description = "金额信息"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class InvoiceDetailAmountInfo {

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;
    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;
    @JsonProperty("quantity")
    private BigDecimal quantity = null;
    @JsonProperty("taxDedunction")
    private BigDecimal taxDedunction = null;
    @JsonProperty("unitPrice")
    private BigDecimal unitPrice = null;

    public InvoiceDetailAmountInfo(BigDecimal amountWithoutTax, BigDecimal taxAmount, BigDecimal quantity, BigDecimal taxDedunction, BigDecimal unitPrice) {
        this.amountWithoutTax = amountWithoutTax;
        this.taxAmount = taxAmount;
        this.quantity = quantity;
        this.taxDedunction = taxDedunction;
        this.unitPrice = unitPrice;
    }

    public InvoiceDetailAmountInfo() {
    }

    @JsonIgnore
    public InvoiceDetailAmountInfo unitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @ApiModelProperty("不含税单价（最多保留小数点后15位）")
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @JsonIgnore
    public InvoiceDetailAmountInfo quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty("数量（保留小数点后10位）")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    @JsonIgnore
    public InvoiceDetailAmountInfo amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税金额（保留小数点后2位）")
    public BigDecimal getAmountWithoutTax() {
        return this.amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public InvoiceDetailAmountInfo taxDedunction(BigDecimal taxDedunction) {
        this.taxDedunction = taxDedunction;
        return this;
    }

    @ApiModelProperty("扣除额(差额征税)（保留小数点后2位）")
    public BigDecimal getTaxDedunction() {
        return this.taxDedunction;
    }

    public void setTaxDedunction(BigDecimal taxDedunction) {
        this.taxDedunction = taxDedunction;
    }

    @JsonIgnore
    public InvoiceDetailAmountInfo taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty("税额")
    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoiceDetailAmountInfo that = (InvoiceDetailAmountInfo) o;
        return Objects.equals(amountWithoutTax, that.amountWithoutTax) &&
                Objects.equals(taxAmount, that.taxAmount) &&
                Objects.equals(quantity, that.quantity) &&
                Objects.equals(taxDedunction, that.taxDedunction) &&
                Objects.equals(unitPrice, that.unitPrice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amountWithoutTax, taxAmount, quantity, taxDedunction, unitPrice);
    }

    @Override
    public String toString() {
        return "InvoiceDetailAmountInfo{" +
                "amountWithoutTax=" + amountWithoutTax +
                ", taxAmount=" + taxAmount +
                ", quantity=" + quantity +
                ", taxDedunction=" + taxDedunction +
                ", unitPrice=" + unitPrice +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}

