package com.xforceplus.seller.invoice.client.api;


import com.xforceplus.maintenance.model.GroupFiltersConditionRequest;
import com.xforceplus.seller.invoice.client.model.MsGetRedNoListByInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.MsGetRedNoListByInvoiceResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@Api(value = "redNotificationDevOps", description = "运维红字信息管理api")
public interface RedNotificationDevOpsApi {

    @ApiOperation(value = "下发红字信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "RedNotificationDevOps", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/pushRedNotification",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response pushRedNotification(@ApiParam(value = "request", required = true) @RequestBody List<Long> redNoIds);


    @ApiOperation(value = "根据分组条件获取发票列表", notes = "", response = MsGetRedNoListByInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetRedNoListByInvoiceResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoListByGroupCondition",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetRedNoListByInvoiceResponse getRedNoListByGroupCondition(@ApiParam(value = "request", required = true) @RequestBody GroupFiltersConditionRequest request);
}
