package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@ApiModel("内部下发总线消息")
@Data
public class BusMessageModel {
    @ApiModelProperty("下发消息唯一标识")
    private Long msgId;
    @ApiModelProperty("消息类型")
    private Integer msgType;
    @ApiModelProperty("购方租户Id")
    private Long sellerTenantId;
    @ApiModelProperty("销方租户Id")
    private Long purchaserTenantId;
    @ApiModelProperty("AR/AP类型")
    private String businessBillType;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("业务单类型")
    private String billType;
    @ApiModelProperty("扩展透传属性")
    private Map<String, Object> extAttributeMap;
    @ApiModelProperty("透传header属性")
    private Map<String, Object> header;
}
