package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/4/25 21:20
 */
@ApiModel(description = "业务系统发票取消操作响应")

@JsonInclude(NON_NULL)
public class InvoiceOperationCancelResponse {

    @JsonProperty("invoiceCode")
    @ApiModelProperty(value = "发票号码")
    private String invoiceCode;

    @JsonProperty("invoiceNo")
    @ApiModelProperty(value = "发票代码")
    private String invoiceNo;

    @JsonProperty("message")
    @ApiModelProperty(value = "处理消息")
    private String message;

    @JsonProperty("code")
    @ApiModelProperty(value = "处理结果")
    private Integer code;


    public static InvoiceOperationCancelResponse fail(String invoiceCode, String invoiceNo, String message){
        return of(invoiceCode, invoiceNo, message, Response.Fail);
    }

    /**
     * 快速成功
     * @param invoiceCode 发票代码
     * @param invoiceNo   发票号码
     * @param message     消息
     * @return
     */
    public static InvoiceOperationCancelResponse ok(String invoiceCode, String invoiceNo, String message){
        return of(invoiceCode, invoiceNo, message, Response.OK);
    }

    private static InvoiceOperationCancelResponse of(String invoiceCode, String invoiceNo, String message, Integer code){
        InvoiceOperationCancelResponse resp = new InvoiceOperationCancelResponse();
        resp.setCode(code);
        resp.setInvoiceCode(invoiceCode);
        resp.setInvoiceNo(invoiceNo);
        resp.setMessage(message);
        return resp;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
