package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 修改红字信息请求参数
 */
@ApiModel(description = "修改红字信息请求参数")

@JsonInclude(NON_NULL)
public class ModifyRedInfoRequest {
  @JsonProperty("preInvoiceId")
  private Long preInvoiceId = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("salesbillType")
  private String salesbillType = null;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("sellerGroupId")
  private String sellerGroupId = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("purchaserGroupId")
  private String purchaserGroupId = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @ApiModelProperty(value = "备注")
  @JsonProperty("remark")
  private String remark;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("ext3")
  private String ext3 = null;

  @JsonProperty("ext4")
  private String ext4 = null;

  @JsonProperty("ext5")
  private String ext5 = null;

  @JsonProperty("ext6")
  private String ext6 = null;

  @JsonProperty("ext7")
  private String ext7 = null;

  @JsonProperty("ext8")
  private String ext8 = null;

  @JsonProperty("ext9")
  private String ext9 = null;

  @JsonProperty("ext10")
  private String ext10 = null;

  @JsonProperty("ext11")
  private String ext11 = null;

  @JsonProperty("ext12")
  private String ext12 = null;

  @JsonProperty("ext13")
  private String ext13 = null;

  @JsonProperty("ext14")
  private String ext14 = null;

  @JsonProperty("ext15")
  private String ext15 = null;

  @JsonProperty("ext16")
  private String ext16 = null;

  @JsonProperty("ext17")
  private String ext17 = null;

  @JsonProperty("ext18")
  private String ext18 = null;

  @JsonProperty("ext19")
  private String ext19 = null;

  @JsonProperty("ext20")
  private String ext20 = null;

  @JsonProperty("ext21")
  private String ext21 = null;

  @JsonProperty("ext22")
  private String ext22 = null;

  @JsonProperty("ext23")
  private String ext23 = null;

  @JsonProperty("ext24")
  private String ext24 = null;

  @JsonProperty("ext25")
  private String ext25 = null;

  @JsonProperty("originInvoiceType")
  private String originInvoiceType = null;

  @JsonProperty("originPaperDrawDate")
  private String originPaperDrawDate = null;

  @JsonProperty("processFlag")
  private String processFlag = null;

  @JsonProperty("processRemark")
  private String processRemark = null;

  @ApiModelProperty("开具原因")
  @Getter
  @Setter
  private String makingReason = null;

  public String getProcessFlag() {
    return processFlag;
  }

  public void setProcessFlag(String processFlag) {
    this.processFlag = processFlag;
  }

  public String getProcessRemark() {
    return processRemark;
  }

  public void setProcessRemark(String processRemark) {
    this.processRemark = processRemark;
  }

  public String getOriginInvoiceType() {
        return originInvoiceType;
    }

    public void setOriginInvoiceType(String originInvoiceType) {
        this.originInvoiceType = originInvoiceType;
    }

    public String getOriginPaperDrawDate() {
        return originPaperDrawDate;
    }

    public void setOriginPaperDrawDate(String originPaperDrawDate) {
        this.originPaperDrawDate = originPaperDrawDate;
    }

    public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public ModifyRedInfoRequest preInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
    return this;
  }

   /**
   * 预制发票Id
   * @return preInvoiceId
  **/
  @ApiModelProperty(value = "预制发票Id")
  public Long getPreInvoiceId() {
    return preInvoiceId;
  }

  public void setPreInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
  }

  @JsonIgnore
  public ModifyRedInfoRequest originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

   /**
   * 源发票号码
   * @return originInvoiceNo
  **/
  @ApiModelProperty(value = "源发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public ModifyRedInfoRequest originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

   /**
   * 源发票号码
   * @return originInvoiceCode
  **/
  @ApiModelProperty(value = "源发票号码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public ModifyRedInfoRequest redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return redNotificationNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public ModifyRedInfoRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public ModifyRedInfoRequest salesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
    return this;
  }
  /**
   * 单据类型
   * @return sellerNo
   **/
  @ApiModelProperty(value = "单据类型")
  public String getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
  }


  @JsonIgnore
  public ModifyRedInfoRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }
  /**
   * AR or AP
   * @return sellerNo
   **/
  @ApiModelProperty(value = "AR or AP")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }


  @JsonIgnore
  public ModifyRedInfoRequest sellerGroupId(String sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
    return this;
  }
  /**
   * 销方groupId
   * @return sellerNo
   **/
  @ApiModelProperty(value = "销方groupId")
  public String getSellerGroupId() {
    return sellerGroupId;
  }

  public void setSellerGroupId(String sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
  }

  @JsonIgnore
  public ModifyRedInfoRequest purchaserGroupId(String purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }
  /**
   * 购方groupId
   * @return sellerNo
   **/
  @ApiModelProperty(value = "购方groupId")
  public String getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(String purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }


  @JsonIgnore
  public ModifyRedInfoRequest sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

  /**
   * 销方编号
   * @return sellerNo
   **/
  @ApiModelProperty(value = "销方编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public ModifyRedInfoRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

  /**
   * 销方名称
   * @return sellerName
   **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public ModifyRedInfoRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

  /**
   * 销方税号
   * @return sellerTaxNo
   **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }
  
  @JsonIgnore
  public ModifyRedInfoRequest purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

  /**
   * 购方编号
   * @return purchaserNo
   **/
  @ApiModelProperty(value = "购方编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public ModifyRedInfoRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

  /**
   * 购方名称
   * @return purchaserName
   **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public ModifyRedInfoRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

  /**
   * 购方税号
   * @return purchaserTaxNo
   **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }
  

  @JsonIgnore
  public ModifyRedInfoRequest ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

  /**
   * null
   * @return ext1
   **/
  @ApiModelProperty(value = "null")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

  /**
   * null
   * @return ext2
   **/
  @ApiModelProperty(value = "null")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext3(String ext3) {
    this.ext3 = ext3;
    return this;
  }

  /**
   * null
   * @return ext3
   **/
  @ApiModelProperty(value = "null")
  public String getExt3() {
    return ext3;
  }

  public void setExt3(String ext3) {
    this.ext3 = ext3;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext4(String ext4) {
    this.ext4 = ext4;
    return this;
  }

  /**
   * null
   * @return ext4
   **/
  @ApiModelProperty(value = "null")
  public String getExt4() {
    return ext4;
  }

  public void setExt4(String ext4) {
    this.ext4 = ext4;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext5(String ext5) {
    this.ext5 = ext5;
    return this;
  }

  /**
   * null
   * @return ext5
   **/
  @ApiModelProperty(value = "null")
  public String getExt5() {
    return ext5;
  }

  public void setExt5(String ext5) {
    this.ext5 = ext5;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext6(String ext6) {
    this.ext6 = ext6;
    return this;
  }

  /**
   * null
   * @return ext6
   **/
  @ApiModelProperty(value = "null")
  public String getExt6() {
    return ext6;
  }

  public void setExt6(String ext6) {
    this.ext6 = ext6;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext7(String ext7) {
    this.ext7 = ext7;
    return this;
  }

  /**
   * null
   * @return ext7
   **/
  @ApiModelProperty(value = "null")
  public String getExt7() {
    return ext7;
  }

  public void setExt7(String ext7) {
    this.ext7 = ext7;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext8(String ext8) {
    this.ext8 = ext8;
    return this;
  }

  /**
   * null
   * @return ext8
   **/
  @ApiModelProperty(value = "null")
  public String getExt8() {
    return ext8;
  }

  public void setExt8(String ext8) {
    this.ext8 = ext8;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext9(String ext9) {
    this.ext9 = ext9;
    return this;
  }

  /**
   * null
   * @return ext9
   **/
  @ApiModelProperty(value = "null")
  public String getExt9() {
    return ext9;
  }

  public void setExt9(String ext9) {
    this.ext9 = ext9;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext10(String ext10) {
    this.ext10 = ext10;
    return this;
  }

  /**
   * null
   * @return ext10
   **/
  @ApiModelProperty(value = "null")
  public String getExt10() {
    return ext10;
  }

  public void setExt10(String ext10) {
    this.ext10 = ext10;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext11(String ext11) {
    this.ext11 = ext11;
    return this;
  }

  /**
   * null
   * @return ext11
   **/
  @ApiModelProperty(value = "null")
  public String getExt11() {
    return ext11;
  }

  public void setExt11(String ext11) {
    this.ext11 = ext11;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext12(String ext12) {
    this.ext12 = ext12;
    return this;
  }

  /**
   * null
   * @return ext12
   **/
  @ApiModelProperty(value = "null")
  public String getExt12() {
    return ext12;
  }

  public void setExt12(String ext12) {
    this.ext12 = ext12;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext13(String ext13) {
    this.ext13 = ext13;
    return this;
  }

  /**
   * null
   * @return ext13
   **/
  @ApiModelProperty(value = "null")
  public String getExt13() {
    return ext13;
  }

  public void setExt13(String ext13) {
    this.ext13 = ext13;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext14(String ext14) {
    this.ext14 = ext14;
    return this;
  }

  /**
   * null
   * @return ext14
   **/
  @ApiModelProperty(value = "null")
  public String getExt14() {
    return ext14;
  }

  public void setExt14(String ext14) {
    this.ext14 = ext14;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext15(String ext15) {
    this.ext15 = ext15;
    return this;
  }

  /**
   * null
   * @return ext15
   **/
  @ApiModelProperty(value = "null")
  public String getExt15() {
    return ext15;
  }

  public void setExt15(String ext15) {
    this.ext15 = ext15;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext16(String ext16) {
    this.ext16 = ext16;
    return this;
  }

  /**
   * null
   * @return ext16
   **/
  @ApiModelProperty(value = "null")
  public String getExt16() {
    return ext16;
  }

  public void setExt16(String ext16) {
    this.ext16 = ext16;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext17(String ext17) {
    this.ext17 = ext17;
    return this;
  }

  /**
   * null
   * @return ext17
   **/
  @ApiModelProperty(value = "null")
  public String getExt17() {
    return ext17;
  }

  public void setExt17(String ext17) {
    this.ext17 = ext17;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext18(String ext18) {
    this.ext18 = ext18;
    return this;
  }

  /**
   * null
   * @return ext18
   **/
  @ApiModelProperty(value = "null")
  public String getExt18() {
    return ext18;
  }

  public void setExt18(String ext18) {
    this.ext18 = ext18;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext19(String ext19) {
    this.ext19 = ext19;
    return this;
  }

  /**
   * null
   * @return ext19
   **/
  @ApiModelProperty(value = "null")
  public String getExt19() {
    return ext19;
  }

  public void setExt19(String ext19) {
    this.ext19 = ext19;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext20(String ext20) {
    this.ext20 = ext20;
    return this;
  }

  /**
   * null
   * @return ext20
   **/
  @ApiModelProperty(value = "null")
  public String getExt20() {
    return ext20;
  }

  public void setExt20(String ext20) {
    this.ext20 = ext20;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext21(String ext21) {
    this.ext21 = ext21;
    return this;
  }

  /**
   * null
   * @return ext21
   **/
  @ApiModelProperty(value = "null")
  public String getExt21() {
    return ext21;
  }

  public void setExt21(String ext21) {
    this.ext21 = ext21;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext22(String ext22) {
    this.ext22 = ext22;
    return this;
  }

  /**
   * null
   * @return ext22
   **/
  @ApiModelProperty(value = "null")
  public String getExt22() {
    return ext22;
  }

  public void setExt22(String ext22) {
    this.ext22 = ext22;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext23(String ext23) {
    this.ext23 = ext23;
    return this;
  }

  /**
   * null
   * @return ext23
   **/
  @ApiModelProperty(value = "null")
  public String getExt23() {
    return ext23;
  }

  public void setExt23(String ext23) {
    this.ext23 = ext23;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext24(String ext24) {
    this.ext24 = ext24;
    return this;
  }

  /**
   * null
   * @return ext24
   **/
  @ApiModelProperty(value = "null")
  public String getExt24() {
    return ext24;
  }

  public void setExt24(String ext24) {
    this.ext24 = ext24;
  }

  @JsonIgnore
  public ModifyRedInfoRequest ext25(String ext25) {
    this.ext25 = ext25;
    return this;
  }

  /**
   * null
   * @return ext25
   **/
  @ApiModelProperty(value = "null")
  public String getExt25() {
    return ext25;
  }

  public void setExt25(String ext25) {
    this.ext25 = ext25;
  }

  @Override
  public String toString() {
    return "ModifyRedInfoRequest{" +
            "preInvoiceId=" + preInvoiceId +
            ", originInvoiceNo='" + originInvoiceNo + '\'' +
            ", originInvoiceCode='" + originInvoiceCode + '\'' +
            ", redNotificationNo='" + redNotificationNo + '\'' +
            ", invoiceType='" + invoiceType + '\'' +
            ", salesbillType='" + salesbillType + '\'' +
            ", businessBillType='" + businessBillType + '\'' +
            ", sellerGroupId='" + sellerGroupId + '\'' +
            ", sellerName='" + sellerName + '\'' +
            ", sellerTaxNo='" + sellerTaxNo + '\'' +
            ", sellerNo='" + sellerNo + '\'' +
            ", purchaserGroupId='" + purchaserGroupId + '\'' +
            ", purchaserName='" + purchaserName + '\'' +
            ", purchaserTaxNo='" + purchaserTaxNo + '\'' +
            ", purchaserNo='" + purchaserNo + '\'' +
            ", ext1='" + ext1 + '\'' +
            ", ext2='" + ext2 + '\'' +
            ", ext3='" + ext3 + '\'' +
            ", ext4='" + ext4 + '\'' +
            ", ext5='" + ext5 + '\'' +
            ", ext6='" + ext6 + '\'' +
            ", ext7='" + ext7 + '\'' +
            ", ext8='" + ext8 + '\'' +
            ", ext9='" + ext9 + '\'' +
            ", ext10='" + ext10 + '\'' +
            ", ext11='" + ext11 + '\'' +
            ", ext12='" + ext12 + '\'' +
            ", ext13='" + ext13 + '\'' +
            ", ext14='" + ext14 + '\'' +
            ", ext15='" + ext15 + '\'' +
            ", ext16='" + ext16 + '\'' +
            ", ext17='" + ext17 + '\'' +
            ", ext18='" + ext18 + '\'' +
            ", ext19='" + ext19 + '\'' +
            ", ext20='" + ext20 + '\'' +
            ", ext21='" + ext21 + '\'' +
            ", ext22='" + ext22 + '\'' +
            ", ext23='" + ext23 + '\'' +
            ", ext24='" + ext24 + '\'' +
            ", ext25='" + ext25 + '\'' +
            '}';
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
