package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoUploadResultRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("taskId")
  private Long taskId = null;

  @JsonIgnore
  public MsGetRedNoUploadResultRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AP：购方 AR-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsGetRedNoUploadResultRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1 销方 2购方
   * @return userRole
  **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsGetRedNoUploadResultRequest taskId(Long taskId) {
    this.taskId = taskId;
    return this;
  }

   /**
   * 任务id
   * @return taskId
  **/
  @ApiModelProperty(value = "任务id")
  public Long getTaskId() {
    return taskId;
  }

  public void setTaskId(Long taskId) {
    this.taskId = taskId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoUploadResultRequest getRedNoUploadResultRequest = (MsGetRedNoUploadResultRequest) o;
    return Objects.equals(this.businessBillType, getRedNoUploadResultRequest.businessBillType) &&
        Objects.equals(this.userRole, getRedNoUploadResultRequest.userRole) &&
        Objects.equals(this.taskId, getRedNoUploadResultRequest.taskId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, userRole, taskId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoUploadResultRequest {\n");

    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
