package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 红冲轮询结果对象
 */
@ApiModel(description = "红冲轮询结果对象")

@JsonInclude(NON_NULL)
public class PollingRedFlushInvoiceResult extends PollingModel {

    @ApiModelProperty(value = "红冲发票失败总数")
    private int failedCount = 0;
    @ApiModelProperty(value = "红冲发票成功总数")
    private int successCount = 0;
    @ApiModelProperty(value = "红冲发票处理结果代码")
    private String code;

    public int getFailedCount() {
        return failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public int getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public String getCode() {  return code; }

    public void setCode(String code) { this.code = code; }

    @Override
    public String toString() {
        return "PollingRedFlushInvoiceResult{" +
                "failedCount=" + failedCount + "successCount" + successCount + "code='" + code + '\'' +
                "} " + super.toString();
    }
}
