package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
@Data
public class PreInvoice {
    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("batchNo")
    private Long batchNo = null;

    @ApiModelProperty("外部批次号")
    private Long outBatchNo;

    @JsonProperty("sellerTenantId")
    private String sellerTenantId = null;

    @ApiModelProperty("销方集团Id")
    @Getter
    @Setter
    @JsonProperty("sellerGroupId")
    private String sellerGroupId = null;

    @ApiModelProperty("销方公司Id")
    @Getter
    @Setter
    @JsonProperty("sellerId")
    private String sellerId = null;

    @ApiModelProperty("预制发票状态")
    @Getter
    @Setter
    @JsonProperty("status")
    private Integer status;

    @JsonProperty("sellerNo")
    private String sellerNo = null;

    @JsonProperty("sellerCode")
    private String sellerCode = null;

    @JsonProperty("sellerName")
    private String sellerName = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("sellerTel")
    private String sellerTel = null;

    @JsonProperty("sellerAddress")
    private String sellerAddress = null;

    @JsonProperty("sellerBankName")
    private String sellerBankName = null;

    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;

    @JsonProperty("purchaserName")
    private String purchaserName = null;

    @JsonProperty("purchaserTenantId")
    private String purchaserTenantId = null;

    @ApiModelProperty("购方集团Id")
    @Getter
    @Setter
    @JsonProperty("purchaserGroupId")
    private String purchaserGroupId = null;

    @JsonProperty("purchaserId")
    private String purchaserId = null;

    @JsonProperty("purchaserNo")
    private String purchaserNo = null;

    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;

    @JsonProperty("purchaserTel")
    private String purchaserTel = null;

    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;

    @JsonProperty("purchaserBankName")
    private String purchaserBankName = null;

    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;

    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @JsonProperty("businessBillType")
    private String businessBillType = null;

    @JsonProperty("salesbillType")
    private String salesbillType = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("machineCode")
    private String machineCode = null;

    @JsonProperty("paperDrawDate")
    private String paperDrawDate = null;

    @JsonProperty("checkCode")
    private String checkCode = null;

    @JsonProperty("cashierName")
    private String cashierName = null;

    @JsonProperty("checkerName")
    private String checkerName = null;

    @JsonProperty("invoicerName")
    private String invoicerName = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("electronicSignature")
    private String electronicSignature = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("cipherText")
    private String cipherText = null;

    @JsonProperty("cipherTextTwoCode")
    private String cipherTextTwoCode = null;

    @ApiModelProperty("销货清单文件打印标志 (0-否, 1-是)")
    private int saleListFileFlag;

    @ApiModelProperty("打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)")
    private int displayPriceQuality;

    @ApiModelProperty("显示税率")
    private String taxRateStr;

    @ApiModelProperty("显示税额")
    private String taxAmountStr;

    @ApiModelProperty("显示不含税金额")
    private String amountWithoutTaxStr;

    @ApiModelProperty("显示含税金额")
    private String amountWithTaxStr;

    @ApiModelProperty("特殊发票标记  0-默认  1-通行费   2-成品油")
    private String specialInvoiceFlag;

    @ApiModelProperty("红字信息编号")
    @Getter
    @Setter
    private String redNotificationNo;

    @ApiModelProperty("原发票号码")
    @Getter
    @Setter
    private String originInvoiceNo;

    @ApiModelProperty("原发票代码")
    @Getter
    @Setter
    private String originInvoiceCode;

    @ApiModelProperty("原发票类型")
    @Getter
    @Setter
    private String originInvoiceType;

    @ApiModelProperty("原开票日期")
    @Getter
    @Setter
    private String originPaperDrawDate;

    @ApiModelProperty("处理标记")
    @Getter
    @Setter
    private String processFlag;

    @ApiModelProperty("处理备注")
    @Getter
    @Setter
    private String processRemark;

    @ApiModelProperty("开具原因")
    @Getter
    @Setter
    private String makingReason;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;

    @ApiModelProperty("发票票种")
    private String invoiceKind;

    @ApiModelProperty("机动车信息")
    @Getter
    @Setter
    private SellerPreInvoiceVehicleInfo preInvoiceVehicleInfo;

    @JsonProperty("preInvoiceDetails")
    private List<PreInvoiceDetail> preInvoiceDetails = new ArrayList<PreInvoiceDetail>();

}
