package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票明细信息
 */
@ApiModel(description = "预制发票明细信息")

@JsonInclude(NON_NULL)
@Data
public class PreInvoiceDetail {

    @ApiModelProperty("单据id")
    private Long billId;

    @ApiModelProperty("单据明细id")
    private Long billItemId;


    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("preInvoiceId")
    private Long preInvoiceId = null;

    @JsonProperty("goodsTaxNo")
    private String goodsTaxNo = null;

    @JsonProperty("cargoName")
    private String cargoName = null;

    @JsonProperty("cargoCode")
    private String cargoCode = null;

    @JsonProperty("itemSpec")
    private String itemSpec = null;

    @JsonProperty("unitPrice")
    private BigDecimal unitPrice = null;

    @JsonProperty("quantity")
    private BigDecimal quantity = null;

    @JsonProperty("quantityUnit")
    private String quantityUnit = null;

    @JsonProperty("taxRate")
    private BigDecimal taxRate = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("discountWithoutTax")
    private BigDecimal discountWithoutTax = null;

    @JsonProperty("discountTax")
    private BigDecimal discountTax = null;

    @JsonProperty("discountWithTax")
    private BigDecimal discountWithTax = null;

    @JsonProperty("discountRate")
    private BigDecimal discountRate = null;

    @JsonProperty("floatingAmount")
    private BigDecimal floatingAmount = null;

    @JsonProperty("taxItem")
    private String taxItem = null;

    @JsonProperty("goodsNoVer")
    private String goodsNoVer = null;

    @JsonProperty("taxPre")
    private String taxPre = null;

    @JsonProperty("taxPreCon")
    private String taxPreCon = null;

    @JsonProperty("zeroTax")
    private String zeroTax = null;

    @JsonProperty("deduction")
    private BigDecimal deduction = null;

    @JsonProperty("discountFlag")
    private String discountFlag = null;

    @JsonProperty("priceMethod")
    private String priceMethod = null;

    @JsonProperty("printContentFlag")
    private String printContentFlag = null;

    @ApiModelProperty(value = "显示税率")
    private String taxRateStr;

    @ApiModelProperty("显示税额")
    private String taxAmountStr;

    @ApiModelProperty("预制发票修改标记 0-未修改过 0>-修改次数， 这个标记字段从业务单传递过来的")
    private Integer modifyMark;

    @ApiModelProperty("发生自动组合合并前的业务单明细Id")
    private List<Long> salesBillItemIds;

    @ApiModelProperty(value = "显示单价")
    private String unitPriceStr;

    @ApiModelProperty("土地增值税项目编号")
    private String landVatItemNo;
    @ApiModelProperty("跨地市标志")
    private String crossCitySign;
    @ApiModelProperty("发生详细地址")
    private String placeOfOccurrence;
    @ApiModelProperty("建筑项目名称")
    private String entryName;
    @ApiModelProperty("建筑服务发生地")
    private String place;

    @ApiModelProperty("运输工具种类")
    private String toolType;
    @ApiModelProperty("运输工具牌号")
    private String toolBrand;
    @ApiModelProperty("运输货物名称")
    private String nameOfGoods;
    @ApiModelProperty("起运地")
    private String placeOfShipment;
    @ApiModelProperty("到达地")
    private String destination;

    @ApiModelProperty("不动产详细地址")
    private String realEstateAddress;
    @ApiModelProperty("不动产单元代码/网签合同备案编码")
    private String realEstateCode;
    @ApiModelProperty("核定计税价格")
    private String taxablePrice;
    @ApiModelProperty("实际成交含税金额")
    private String transactionPrice;
    @ApiModelProperty("不动产地址（省市区）")
    private String realEstatePlace;
    @ApiModelProperty("房屋产权证书/不动产权证号码")
    private String realEstateNo;
    @ApiModelProperty("面积单位")
    private String areaUnit;

    @ApiModelProperty("租赁期起")
    private String leaseTermStart;
    @ApiModelProperty("租赁期止")
    private String leaseTermEnd;
}
