package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "查询已匹配发票请求参数")
@JsonInclude(NON_NULL)
public class QuerySalesMatchInvoicesRequest extends SearchModel {

    @JsonProperty("invoiceNo")
    private String invoiceNo;
    @JsonProperty("invoiceCode")
    private String invoiceCode;
    @JsonProperty("recogResponseTimeStart")
    private Date recogResponseTimeStart;
    @JsonProperty("recogResponseTimeEnd")
    private Date recogResponseTimeEnd;
    @JsonProperty("invoiceIds")
    private List<Long> invoiceIds;

    @ApiModelProperty(value = "发票ids")
    public List<Long> getInvoiceIds() {
        return invoiceIds;
    }

    public void setInvoiceIds(List<Long> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }

    @ApiModelProperty(value = "发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @ApiModelProperty(value = "发票号码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @ApiModelProperty(value = "开始时间")
    public Date getRecogResponseTimeStart() {
        return recogResponseTimeStart;
    }

    public void setRecogResponseTimeStart(Date recogResponseTimeStart) {
        this.recogResponseTimeStart = recogResponseTimeStart;
    }

    @ApiModelProperty(value = "截止时间")
    public Date getRecogResponseTimeEnd() {
        return recogResponseTimeEnd;
    }

    public void setRecogResponseTimeEnd(Date recogResponseTimeEnd) {
        this.recogResponseTimeEnd = recogResponseTimeEnd;
    }


}
