package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票信息
 */
@ApiModel(description = "发票信息")

@JsonInclude(NON_NULL)
public class QuerySellerInvoice {

    @JsonProperty("invoice")
    private SellerInvoiceInfo invoice;

    @JsonProperty("items")
    private List<InvoiceItem> items;


    @JsonProperty("sellerInvoiceVehicleInfo")
    @Getter
    @Setter
    private SellerInvoiceVehicleInfo sellerInvoiceVehicleInfo = null;


    @ApiModelProperty(value = "发票主信息")
    public SellerInvoiceInfo getInvoice() {
        return invoice;
    }

    public void setInvoice(SellerInvoiceInfo invoice) {
        this.invoice = invoice;
    }

    @ApiModelProperty(value = "发票明细信息")
    public List<InvoiceItem> getItems() {
        return items;
    }

    public void setItems(List<InvoiceItem> items) {
        this.items = items;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((invoice == null) ? 0 : invoice.hashCode());
        result = prime * result + ((items == null) ? 0 : items.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QuerySellerInvoice other = (QuerySellerInvoice) obj;
        if (invoice == null) {
            if (other.invoice != null)
                return false;
        } else if (!invoice.equals(other.invoice))
            return false;
        if (items == null) {
            if (other.items != null)
                return false;
        } else if (!items.equals(other.items))
            return false;
        return true;
    }

}
