package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.operation.ItemInfo;
import com.xforceplus.seller.invoice.client.model.update.OperationConfigItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 红冲校验接口结果
 */
@ApiModel(description = "红冲校验接口结果")

@JsonInclude(NON_NULL)
@Getter
@Setter
public class RedflushInvoiceCheckResult {

    @ApiModelProperty(value = "查询红字信息表申请结果")
    @JsonProperty("invSellerRedNotificationLogDto")
    private InvSellerRedNotificationLogDto invSellerRedNotificationLogDto;

    @ApiModelProperty(value = "校验结果 0-校验失败 1-校验成功")
    @JsonProperty("checked")
    private Integer checked;

    @ApiModelProperty(value = "校验结果失败信息")
    @JsonProperty("message")
    private String message ;

    @ApiModelProperty(value = "发票红冲释放方式")
    @JsonProperty("checkConfigs")
    private List<OperationConfigItem> checkConfigs;

    @ApiModelProperty(value = "可红冲发票id列表")
    @JsonProperty("invoiceIds")
    private List<String> invoiceIds;

    @ApiModelProperty(value = "含税总金额")
    @JsonProperty("totalAmountWithTax")
    private BigDecimal totalAmountWithTax ;

    @ApiModelProperty(value = "不含税总金额")
    @JsonProperty("totalAmountWithOutTax")
    private BigDecimal totalAmountWithOutTax ;


    @ApiModelProperty(value = "税额")
    @JsonProperty("taxAmount")
    private BigDecimal taxAmount ;

    @ApiModelProperty(value = "发票号码")
    @JsonProperty("invoiceNo")
    private String invoiceNo ;

    @ApiModelProperty(value = "发票代码")
    @JsonProperty("invoiceCode")
    private String invoiceCode ;

    @ApiModelProperty(value = "销方公司")
    @JsonProperty("componyName")
    private String componyName ;

    @ApiModelProperty("是否发起审批申请")
    @JsonProperty("invoiceApplyAuditFlag")
    private Integer invoiceApplyAuditFlag;

    @ApiModelProperty("外部申请或内部申请")
    @JsonProperty("invoiceInnerOrGatewayAudit")
    private String invoiceInnerOrGatewayAudit;

    @ApiModelProperty("外部url")
    @JsonProperty("gateWayUrl")
    private String gateWayUrl;

    @ApiModelProperty("是否跳转至外部系统")
    @JsonProperty("skipFlag")
    private int skipFlag;

    @ApiModelProperty(value = "红冲原因列表")
    @JsonProperty("redflushOperation")
    private List<ItemInfo> redflushOperation;

    @ApiModelProperty(value = "红字信息比对信息")
    @JsonProperty("redNoCompareInfo")
    private RedNoCompareInfo redNoCompareInfo;

//    @ApiModelProperty(value = "红字确认单编号")
//    @JsonProperty("redLetterNumber")
//    private String redLetterNumber;

    @ApiModelProperty("申请红字处于申请中的taskId")
    private String taskId;

}
