package com.xforceplus.seller.invoice.client.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票信息
 */
@ApiModel(description = "发票信息")

@JsonInclude(NON_NULL)
@EqualsAndHashCode
@ToString
public class SellerInvoiceInfo {
  @JsonProperty("id")
  @JSONField(serializeUsing = ToStringSerializer.class)
  private Long id = null;

  @JsonProperty("preInvoiceId")
  private Long preInvoiceId = null;

  @JsonProperty("batchNo")
  private Long batchNo = null;

  @JsonProperty("outBatchNo")
  private Long outBatchNo = null;

  @JsonProperty("salesbillId")
  private String salesbillId = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("sellerGroupId")
  private Long sellerGroupId = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerId")
  private Long sellerId = null;

  @JsonProperty("sellerCode")
  private String sellerCode = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("purchaserId")
  private Long purchaserId = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @ApiModelProperty(value = "购方电子支付标识")
  @JsonProperty("purchaserEPayId")
  private String purchaserEPayId = "";

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceKind")
  private String invoiceKind = null;

  @JsonProperty("taxInvoiceSource")
  private String taxInvoiceSource =null;

  @JsonProperty("invoiceColor")
  private String invoiceColor = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @ApiModelProperty(value = "开具方式")
  @JsonProperty("terminalType")
  private int terminalType;

  @JsonProperty("paperDrawDate")

  private Date paperDrawDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("electronicSignature")
  private String electronicSignature = null;

  @JsonProperty("invoiceOrigin")
  private String invoiceOrigin = null;

  @JsonProperty("invoiceFrom")
  private String invoiceFrom = null;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("specialInvoiceFlag")
  private String specialInvoiceFlag = null;

  @JsonProperty("billType")
  private String billType = null;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("taxAmountStr")
  private String taxAmountStr = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxRateStr")
  private String taxRateStr;


  @ApiModelProperty("显示不含税金额")
  private String amountWithoutTaxStr;

  @ApiModelProperty("显示含税金额")
  private String amountWithTaxStr;


  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("cipherTextTwoCode")
  private String cipherTextTwoCode = null;

  @JsonProperty("virtualFlag")
  private String virtualFlag = null;

  @JsonProperty("abandonFlag")
  private String abandonFlag = null;

  @JsonProperty("redTime")

  private Date redTime = null;

  @JsonProperty("redFlag")
  private String redFlag = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("matchedStatus")
  private Integer matchedStatus = null;

  @JsonProperty("saleListFileFlag")
  private Integer saleListFileFlag = null;

  @JsonProperty("printContentFlag")
  private Integer printContentFlag = null;

  @JsonProperty("displayPriceQality")
  private Integer displayPriceQality = null;

  @JsonProperty("ofdPath")
  private String ofdPath;

  @JsonProperty("pdfPath")
  private String pdfPath = null;

  @JsonProperty("receiveUserEmail")
  private String receiveUserEmail = null;

  @JsonProperty("makeOutUnitName")
  private String makeOutUnitName = null;

  @JsonProperty("handleStatus")
  private String handleStatus = null;

  @JsonProperty("handleRemark")
  private String handleRemark = null;

  @JsonProperty("outCheckStatus")
  private String outCheckStatus = null;

  @JsonProperty("lockFlag")
  private Integer lockFlag = null;

  @JsonProperty("identifyStatus")
  private String identifyStatus = null;

  @JsonProperty("printStatus")
  private String printStatus = null;

  @JsonProperty("retreatStatus")
  private String retreatStatus;

  @JsonProperty("paymentStatus")
  private String paymentStatus;

  @JsonProperty("makeOutUnitCode")
  private String makeOutUnitCode = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")

  private Date createTime = null;

  @JsonProperty("createUserId")
  private String createUserId = null;

  @JsonProperty("updateTime")

  private Date updateTime = null;

  @JsonProperty("updateUserId")
  private String updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName;

  @JsonProperty("deposeUserName")
  private String deposeUserName = null;

  @JsonProperty("deposeTime")

  private Date deposeTime = null;

  @JsonProperty("deposeUserId")
  private String deposeUserId = null;

  @JsonProperty("sysOrgId")
  private Long sysOrgId = null;

  @JsonProperty("sysOrgName")
  private String sysOrgName = null;

  @JsonProperty("customerNo")
  private String customerNo = null;

  @JsonProperty("invoiceUrl")
  private String invoiceUrl = null;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("ext3")
  private String ext3 = null;

  @JsonProperty("ext4")
  private String ext4 = null;

  @JsonProperty("ext5")
  private String ext5 = null;

  @JsonProperty("ext6")
  private String ext6 = null;

  @JsonProperty("ext7")
  private String ext7 = null;

  @JsonProperty("ext8")
  private String ext8 = null;

  @JsonProperty("ext9")
  private String ext9 = null;

  @JsonProperty("ext10")
  private String ext10 = null;

  @JsonProperty("ext11")
  private String ext11 = null;

  @JsonProperty("ext12")
  private String ext12 = null;

  @JsonProperty("ext13")
  private String ext13 = null;

  @JsonProperty("ext14")
  private String ext14 = null;

  @JsonProperty("ext15")
  private String ext15 = null;

  @JsonProperty("ext16")
  private String ext16 = null;

  @JsonProperty("ext17")
  private String ext17 = null;

  @JsonProperty("ext18")
  private String ext18 = null;

  @JsonProperty("ext19")
  private String ext19 = null;

  @JsonProperty("ext20")
  private String ext20 = null;

  @JsonProperty("ext21")
  private String ext21 = null;

  @JsonProperty("ext22")
  private String ext22 = null;

  @JsonProperty("ext23")
  private String ext23 = null;

  @JsonProperty("ext24")
  private String ext24 = null;

  @JsonProperty("ext25")
  private String ext25 = null;

  /**
   * 物流 收件人
   * 表 : inv_seller_invoice
   * 对应字段 : addressee
   */
  @JsonProperty("addressee")
  private String addressee = null;

  /**
   * 物流-收件人电话
   * 表 : inv_seller_invoice
   * 对应字段 : addressee_tel
   */
  @JsonProperty("addresseeTel")
  private String addresseeTel = null;

  /**
   * 物流-收件人省份
   * 表 : inv_seller_invoice
   * 对应字段 : addressee_province
   */
  @JsonProperty("addresseeProvince")
  private String addresseeProvince = null;

  /**
   * 物流-收件人城市
   * 表 : inv_seller_invoice
   * 对应字段 : addressee_city
   */
  @JsonProperty("addresseeCity")
  private String addresseeCity = null;

  /**
   * 物流-收件人所在县区
   * 表 : inv_seller_invoice
   * 对应字段 : addressee_county
   */
  @JsonProperty("addresseeCounty")
  private String addresseeCounty = null;

  /**
   * 物流-收件人地址
   * 表 : inv_seller_invoice
   * 对应字段 : direction
   */
  @JsonProperty("direction")
  private String direction = null;

  /**
   * 物流备注
   * 表 : inv_seller_invoice
   * 对应字段 : logistic_remark
   */
  @JsonProperty("logisticRemark")
  private String logisticRemark = null;

  /**
   * 收件人单位
   * 表 : inv_seller_invoice
   * 对应字段 : logistic_remark
   */
  @JsonProperty("addresseeComp")
  private String addresseeComp = null;

  /**
   * 收件人邮编
   * 表 : inv_seller_invoice
   * 对应字段 : logistic_remark
   */
  @JsonProperty("addresseePost")
  private String addresseePost = null;

  @JsonProperty("auditType")
  private Integer auditType;

  /**
   * 设备唯一码
   * 表 : inv_seller_invoice
   * 对应字段 : device_un
   */
  @JsonProperty("deviceUn")
  private String deviceUn;

  /**
   * 终端唯一码
   * 表 : inv_seller_invoice
   * 对应字段 : terminal_un
   */
  @JsonProperty("terminalUn")
  private String terminalUn;

  @JsonProperty("orderNos")
  private String orderNos = null;

  @JsonProperty("discountRate")
  private String discountRate = null;

  public String getDiscountRate() {
    return discountRate;
  }

  public void setDiscountRate(String discountRate) {
    this.discountRate = discountRate;
  }

  private String sellerBankInfo;

  private String sellerAddrTel;

  private String purchaserBankInfo;

  private String purchaserAddrTel;

  private String originPaperDrawDate = null;

  private Integer makeType = 0;

  @Getter
  @Setter
  private String xmlUrl;

  @ApiModelProperty("原发票类型")
  private String originInvoiceType;

  @ApiModelProperty("红冲人")
  private String redUserName;

  @ApiModelProperty("接收人电话")
  private String receiveUserTel;

  @ApiModelProperty("渠道")
  private String channel;

  @ApiModelProperty("全电发票号码")
  private String allElectricInvoiceNo;

  @ApiModelProperty("系统来源类型")
  @Getter
  @Setter
  private Integer systemOrigType;

  public String getOfdPath() {
    return ofdPath;
  }

  public void setOfdPath(String ofdPath) {
    this.ofdPath = ofdPath;
  }

  @JsonIgnore
  public SellerInvoiceInfo id(Long id) {
    this.id = id;
    return this;
  }

  public int getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(int terminalType) {
    this.terminalType = terminalType;
  }

  public String getPurchaserEPayId() {
    return purchaserEPayId;
  }

  public void setPurchaserEPayId(String purchaserEPayId) {
    this.purchaserEPayId = purchaserEPayId;
  }

  /**
   * 发票序列号主键
   * @return id
  **/
  @ApiModelProperty(value = "发票序列号主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public SellerInvoiceInfo preInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
    return this;
  }

   /**
   * 预制发票序列号主键
   * @return preInvoiceId
  **/
  @ApiModelProperty(value = "预制发票序列号主键")
  public Long getPreInvoiceId() {
    return preInvoiceId;
  }

  public void setPreInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
  }

  @JsonIgnore
  public SellerInvoiceInfo batchNo(Long batchNo) {
    this.batchNo = batchNo;
    return this;
  }

   /**
   * 批次号
   * @return batchNo
  **/
  @ApiModelProperty(value = "批次号")
  public Long getBatchNo() {
    return batchNo;
  }

  public void setBatchNo(Long batchNo) {
    this.batchNo = batchNo;
  }

    @JsonIgnore
    public SellerInvoiceInfo outBatchNo(Long outBatchNo) {
        this.outBatchNo = outBatchNo;
        return this;
    }

    /**
     * 外部批次号-默认值和批次号相同
     * @return outBatchNo
     **/
    @ApiModelProperty(value = "批次号")
    public Long getOutBatchNo() {
        return outBatchNo;
    }

    public void setOutBatchNo(Long outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

  @JsonIgnore
  public SellerInvoiceInfo salesbillId(String salesbillId) {
    this.salesbillId = salesbillId;
    return this;
  }

   /**
   * 单据Id
   * @return salesbillId
  **/
  @ApiModelProperty(value = "单据Id")
  public String getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(String salesbillId) {
    this.salesbillId = salesbillId;
  }

  @JsonIgnore
  public SellerInvoiceInfo salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据No
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据No")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerTenantCode(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 销方租户代码
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "销方租户代码")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

  /**
   * 销方集团代码
   * @return sellerGroupId
   **/
  @ApiModelProperty(value = "销方集团代码")
  public Long getSellerGroupId() {
    return sellerGroupId;
  }

  public void setSellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
  }
  /**
   * 购方集团代码
   * @return purchaserGroupId
   **/
  @ApiModelProperty(value = "购方集团代码")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }
  /**
   * 发票红蓝标识
   * @return invoiceColor
   **/
  @ApiModelProperty(value = "发票红蓝标识")
  public String getInvoiceColor() {
    return invoiceColor;
  }

  public void setInvoiceColor(String invoiceColor) {
    this.invoiceColor = invoiceColor;
  }

  /**
   * 销方租户公司编号
   * @return sellerNo
  **/
  @ApiModelProperty(value = "销方租户公司编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
    return this;
  }

   /**
   * 销方公司代码
   * @return sellerCode
  **/
  @ApiModelProperty(value = "销方公司代码")
  public String getSellerCode() {
    return sellerCode;
  }

  public void setSellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public SellerInvoiceInfo sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行账号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserTenantCode(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户代码
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户代码")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserId(Long purchaserId) {
    this.purchaserId = purchaserId;
    return this;
  }

   /**
   * 购方公司Id
   * @return purchaserId
  **/
  @ApiModelProperty(value = "购方公司Id")
  public Long getPurchaserId() {
    return purchaserId;
  }

  public void setPurchaserId(Long purchaserId) {
    this.purchaserId = purchaserId;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

   /**
   * 购方租户公司编号
   * @return purchaserNo
  **/
  @ApiModelProperty(value = "购方租户公司编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public SellerInvoiceInfo purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行账号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public SellerInvoiceInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public SellerInvoiceInfo invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public SellerInvoiceInfo invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public SellerInvoiceInfo paperDrawDate(Date paperDrawDate) {
    this.paperDrawDate = paperDrawDate;
    return this;
  }

   /**
   * 发票开票日期
   * @return paperDrawDate
  **/
  @ApiModelProperty(value = "发票开票日期")
  public Date getPaperDrawDate() {
    return paperDrawDate;
  }

  public void setPaperDrawDate(Date paperDrawDate) {
    this.paperDrawDate = paperDrawDate;
  }

  @JsonIgnore
  public SellerInvoiceInfo checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public SellerInvoiceInfo cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人姓名
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人姓名")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public SellerInvoiceInfo checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人姓名
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人姓名")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public SellerInvoiceInfo invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人姓名
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人姓名")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public SellerInvoiceInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public SellerInvoiceInfo electronicSignature(String electronicSignature) {
    this.electronicSignature = electronicSignature;
    return this;
  }

   /**
   * 电子签名
   * @return electronicSignature
  **/
  @ApiModelProperty(value = "电子签名")
  public String getElectronicSignature() {
    return electronicSignature;
  }

  public void setElectronicSignature(String electronicSignature) {
    this.electronicSignature = electronicSignature;
  }

  @JsonIgnore
  public SellerInvoiceInfo invoiceOrigin(String invoiceOrigin) {
    this.invoiceOrigin = invoiceOrigin;
    return this;
  }

  /**
   * 发票来源
   * @return invoiceOrigin
   **/
  @ApiModelProperty(value = "发票来源")
  public String getInvoiceOrigin() {
    return invoiceOrigin;
  }

  public void setInvoiceOrigin(String invoiceOrigin) {
    this.invoiceOrigin = invoiceOrigin;
  }


  @JsonIgnore
  public SellerInvoiceInfo invoiceFrom(String invoiceFrom) {
    this.invoiceFrom = invoiceFrom;
    return this;
  }

  /**
   * 发票来源方
   * @return invoiceFrom
   **/
  @ApiModelProperty(value = "发票来源方")
  public String getInvoiceFrom() {
    return invoiceFrom;
  }

  public void setInvoiceFrom(String invoiceFrom) {
    this.invoiceFrom = invoiceFrom;
  }


  @JsonIgnore
  public SellerInvoiceInfo systemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

  /**
   * 系统来源
   * @return systemOrig
   **/
  @ApiModelProperty(value = "系统来源")
  public String getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public SellerInvoiceInfo billType(String billType) {
    this.billType = billType;
    return this;
  }

   /**
   * 单据类型
   * @return billType
  **/
  @ApiModelProperty(value = "单据类型")
  public String getBillType() {
    return billType;
  }

  public void setBillType(String billType) {
    this.billType = billType;
  }

  @JsonIgnore
  public SellerInvoiceInfo businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * 适用业务单据类型
   * @return businessBillType
  **/
  @ApiModelProperty(value = "适用业务单据类型")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public SellerInvoiceInfo amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public SellerInvoiceInfo amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public SellerInvoiceInfo taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public SellerInvoiceInfo taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

  @ApiModelProperty("显示税率")
  public String getTaxRateStr() {
    return taxRateStr;
  }

  public void setTaxRateStr(String taxRateStr) {
    this.taxRateStr = taxRateStr;
  }

  @ApiModelProperty("显示税额")
  public String getTaxAmountStr() {
    return taxAmountStr;
  }

  public void setTaxAmountStr(String taxAmountStr) {
    this.taxAmountStr = taxAmountStr;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public SellerInvoiceInfo originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

   /**
   * 原发票号码
   * @return originInvoiceNo
  **/
  @ApiModelProperty(value = "原发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

   /**
   * 原发票代码
   * @return originInvoiceCode
  **/
  @ApiModelProperty(value = "原发票代码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public SellerInvoiceInfo cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public SellerInvoiceInfo cipherTextTwoCode(String cipherTextTwoCode) {
    this.cipherTextTwoCode = cipherTextTwoCode;
    return this;
  }

   /**
   * 二维密文
   * @return cipherTextTwoCode
  **/
  @ApiModelProperty(value = "二维密文")
  public String getCipherTextTwoCode() {
    return cipherTextTwoCode;
  }

  public void setCipherTextTwoCode(String cipherTextTwoCode) {
    this.cipherTextTwoCode = cipherTextTwoCode;
  }

  @JsonIgnore
  public SellerInvoiceInfo virtualFlag(String virtualFlag) {
    this.virtualFlag = virtualFlag;
    return this;
  }

   /**
   * 虚拟标志
   * @return virtualFlag
  **/
  @ApiModelProperty(value = "虚拟标志")
  public String getVirtualFlag() {
    return virtualFlag;
  }

  public void setVirtualFlag(String virtualFlag) {
    this.virtualFlag = virtualFlag;
  }

  @JsonIgnore
  public SellerInvoiceInfo redTime(Date redTime) {
    this.redTime = redTime;
    return this;
  }

   /**
   * 红冲时间
   * @return redTime
  **/
  @ApiModelProperty(value = "红冲时间")
  public Date getRedTime() {
    return redTime;
  }

  public void setRedTime(Date redTime) {
    this.redTime = redTime;
  }

  @JsonIgnore
  public SellerInvoiceInfo redFlag(String redFlag) {
    this.redFlag = redFlag;
    return this;
  }

   /**
   * 红冲状态1-待红冲 2-待部分红冲3-红冲4-部分红冲 （目前该字段没用）
   * @return redFlag
  **/
  @ApiModelProperty(value = "红冲状态1-待红冲 2-待部分红冲3-红冲4-部分红冲 （目前该字段没用）")
  public String getRedFlag() {
    return redFlag;
  }

  public void setRedFlag(String redFlag) {
    this.redFlag = redFlag;
  }

  @JsonIgnore
  public SellerInvoiceInfo redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return redNotificationNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 发票状态1-正常 0-作废 2-待处理 3-已红冲
   * @return status
  **/
  @ApiModelProperty(value = "发票状态1-正常 0-作废 2-待处理 3-已红冲")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public SellerInvoiceInfo matchedStatus(Integer matchedStatus) {
    this.matchedStatus = matchedStatus;
    return this;
  }

  /**
   * 阳光城-生成凭证后锁定、解锁标志  0-解锁  1-锁定
   * @return status
   **/
  @ApiModelProperty(value = "阳光城-生成凭证后锁定、解锁标志  0-解锁  1-锁定")
  public Integer getMatchedStatus() {
    return matchedStatus;
  }

  public void setMatchedStatus(Integer matchedStatus) {
    this.matchedStatus = matchedStatus;
  }

  @JsonIgnore
  public SellerInvoiceInfo saleListFileFlag(Integer saleListFileFlag) {
    this.saleListFileFlag = saleListFileFlag;
    return this;
  }

   /**
   * 销货清单文件打印标志（0-否,1-是）
   * @return saleListFileFlag
  **/
  @ApiModelProperty(value = "销货清单文件打印标志（0-否,1-是）")
  public Integer getSaleListFileFlag() {
    return saleListFileFlag;
  }

  public void setSaleListFileFlag(Integer saleListFileFlag) {
    this.saleListFileFlag = saleListFileFlag;
  }

  @JsonIgnore
  public SellerInvoiceInfo printContentFlag(Integer printContentFlag) {
    this.printContentFlag = printContentFlag;
    return this;
  }

   /**
   * 打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
   * @return printContentFlag
  **/
  @ApiModelProperty(value = "打印内容标志0-打印单价和数量1-不打印单价和数量,默认0")
  public Integer getPrintContentFlag() {
    return printContentFlag;
  }

  public void setPrintContentFlag(Integer printContentFlag) {
    this.printContentFlag = printContentFlag;
  }

  @JsonIgnore
  public SellerInvoiceInfo displayPriceQality(Integer displayPriceQality) {
    this.displayPriceQality = displayPriceQality;
    return this;
  }

  /**
   * 打印内容标志0-打印单价和数量1-不打印单价和数量,默认0
   * 加一个displayPriceQality 字段用printContentFlag的值给前端使用，为了发票和预制发票统一
   * @return displayPriceQality
   **/
  @ApiModelProperty(value = "打印内容标志0-打印单价和数量1-不打印单价和数量,默认0")
  public Integer getDisplayPriceQality() {
    return this.printContentFlag;
  }

  public void setDisplayPriceQality(Integer displayPriceQality) {
    this.displayPriceQality = displayPriceQality;
  }

  @JsonIgnore
  public SellerInvoiceInfo pdfPath(String pdfPath) {
    this.pdfPath = pdfPath;
    return this;
  }

  public String getAmountWithoutTaxStr() {
    return amountWithoutTaxStr;
  }

  public void setAmountWithoutTaxStr(String amountWithoutTaxStr) {
    this.amountWithoutTaxStr = amountWithoutTaxStr;
  }

  public String getAmountWithTaxStr() {
    return amountWithTaxStr;
  }

  public void setAmountWithTaxStr(String amountWithTaxStr) {
    this.amountWithTaxStr = amountWithTaxStr;
  }

  /**
   * pdf路径
   * @return pdfPath
  **/
  @ApiModelProperty(value = "pdf路径")
  public String getPdfPath() {
    return pdfPath;
  }

  public void setPdfPath(String pdfPath) {
    this.pdfPath = pdfPath;
  }

  @JsonIgnore
  public SellerInvoiceInfo makeOutUnitName(String makeOutUnitName) {
    this.makeOutUnitName = makeOutUnitName;
    return this;
  }

   /**
   * 开票点名称
   * @return makeOutUnitName
  **/
  @ApiModelProperty(value = "开票点名称")
  public String getMakeOutUnitName() {
    return makeOutUnitName;
  }

  public void setMakeOutUnitName(String makeOutUnitName) {
    this.makeOutUnitName = makeOutUnitName;
  }

  @JsonIgnore
  public SellerInvoiceInfo handleStatus(String handleStatus) {
    this.handleStatus = handleStatus;
    return this;
  }

   /**
   * 处理状态 1-正常 2-处理中
   * @return handleStatus
  **/
  @ApiModelProperty(value = "处理状态 1-正常 2-处理中")
  public String getHandleStatus() {
    return handleStatus;
  }

  public void setHandleStatus(String handleStatus) {
    this.handleStatus = handleStatus;
  }

  @JsonIgnore
  public SellerInvoiceInfo handleRemark(String handleRemark) {
    this.handleRemark = handleRemark;
    return this;
  }

   /**
   * 处理备注
   * @return handleRemark
  **/
  @ApiModelProperty(value = "处理备注")
  public String getHandleRemark() {
    return handleRemark;
  }

  public void setHandleRemark(String handleRemark) {
    this.handleRemark = handleRemark;
  }

  @JsonIgnore
  public SellerInvoiceInfo lockFlag(Integer lockFlag) {
    this.lockFlag = lockFlag;
    return this;
  }

   /**
   * 锁定状态1-已锁定 0-未锁定
   * @return lockFlag
  **/
  @ApiModelProperty(value = "锁定状态1-已锁定 0-未锁定")
  public Integer getLockFlag() {
    return lockFlag;
  }

  public void setLockFlag(Integer lockFlag) {
    this.lockFlag = lockFlag;
  }

  @JsonIgnore
  public SellerInvoiceInfo identifyStatus(String identifyStatus) {
    this.identifyStatus = identifyStatus;
    return this;
  }

   /**
   * 认证状态1-已转出 2-已认证 0-未认证
   * @return identifyStatus
  **/
  @ApiModelProperty(value = "认证状态1-已转出 2-已认证 0-未认证")
  public String getIdentifyStatus() {
    return identifyStatus;
  }

  public void setIdentifyStatus(String identifyStatus) {
    this.identifyStatus = identifyStatus;
  }

  @JsonIgnore
  public SellerInvoiceInfo printStatus(String printStatus) {
    this.printStatus = printStatus;
    return this;
  }

   /**
   * 打印状态1-已打印 0-未打印
   * @return printStatus
  **/
  @ApiModelProperty(value = "打印状态1-已打印 0-未打印")
  public String getPrintStatus() {
    return printStatus;
  }

  public void setPrintStatus(String printStatus) {
    this.printStatus = printStatus;
  }

  @JsonIgnore
  public SellerInvoiceInfo paymentStatus(String paymentStatus) {
    this.paymentStatus = paymentStatus;
    return this;
  }

  /**
   * 付款状态  0-未付款(默认)    1-部分付款 2-已付款
   * @return paymentStatus
   **/
  @ApiModelProperty(value = "付款状态  0-未付款(默认)    1-部分付款 2-已付款")
  public String getPaymentStatus() {
    return paymentStatus;
  }

  public void setPaymentStatus(String paymentStatus) {
    this.paymentStatus = paymentStatus;
  }

  @JsonIgnore
  public SellerInvoiceInfo retreatStatus(String retreatStatus) {
    this.retreatStatus = retreatStatus;
    return this;
  }

  /**
   * 退票状态  0-未退(默认)  1-已退   2-撤消退票
   * @return retreatStatus
   **/
  @ApiModelProperty(value = "退票状态  0-未退(默认)  1-已退   2-撤消退票")
  public String getRetreatStatus() {
    return retreatStatus;
  }

  public void setRetreatStatus(String retreatStatus) {
    this.retreatStatus = retreatStatus;
  }

  @JsonIgnore
  public SellerInvoiceInfo specialInvoiceFlag(String specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
    return this;
  }

  /**
   * 特殊发票标记  0-默认  1-通行费   2-成品油
   * @return specialInvoiceFlag
   **/
  @ApiModelProperty(value = "特殊发票标记  0-默认  1-通行费   2-成品油")
  public String getSpecialInvoiceFlag() {
    return specialInvoiceFlag;
  }

  public void setSpecialInvoiceFlag(String specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
  }
  @JsonIgnore
  public SellerInvoiceInfo updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

  /**
   * 更新人姓名
   * @return updateUserName
   **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public SellerInvoiceInfo makeOutUnitCode(String makeOutUnitCode) {
    this.makeOutUnitCode = makeOutUnitCode;
    return this;
  }

   /**
   * 开票点代码
   * @return makeOutUnitCode
  **/
  @ApiModelProperty(value = "开票点代码")
  public String getMakeOutUnitCode() {
    return makeOutUnitCode;
  }

  public void setMakeOutUnitCode(String makeOutUnitCode) {
    this.makeOutUnitCode = makeOutUnitCode;
  }

  @JsonIgnore
  public SellerInvoiceInfo createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public SellerInvoiceInfo createTime(Date createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 发票正式信息回填时间
   * @return createTime
  **/
  @ApiModelProperty(value = "发票正式信息回填时间")
  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public SellerInvoiceInfo createUserId(String createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 发票正式信息回填操作账号
   * @return createUserId
  **/
  @ApiModelProperty(value = "发票正式信息回填操作账号")
  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public SellerInvoiceInfo updateTime(Date updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 修改时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "修改时间")
  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public SellerInvoiceInfo updateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新账号
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新账号")
  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public SellerInvoiceInfo deposeUserName(String deposeUserName) {
    this.deposeUserName = deposeUserName;
    return this;
  }

   /**
   * 作废的人名字
   * @return deposeUserName
  **/
  @ApiModelProperty(value = "作废的人名字")
  public String getDeposeUserName() {
    return deposeUserName;
  }

  public void setDeposeUserName(String deposeUserName) {
    this.deposeUserName = deposeUserName;
  }

  @JsonIgnore
  public SellerInvoiceInfo deposeTime(Date deposeTime) {
    this.deposeTime = deposeTime;
    return this;
  }

   /**
   * 作废时间
   * @return deposeTime
  **/
  @ApiModelProperty(value = "作废时间")
  public Date getDeposeTime() {
    return deposeTime;
  }

  public void setDeposeTime(Date deposeTime) {
    this.deposeTime = deposeTime;
  }

  @JsonIgnore
  public SellerInvoiceInfo deposeUserId(String deposeUserId) {
    this.deposeUserId = deposeUserId;
    return this;
  }

   /**
   * 作废操作账号
   * @return deposeUserId
  **/
  @ApiModelProperty(value = "作废操作账号")
  public String getDeposeUserId() {
    return deposeUserId;
  }

  public void setDeposeUserId(String deposeUserId) {
    this.deposeUserId = deposeUserId;
  }

  @JsonIgnore
  public SellerInvoiceInfo customerNo(String customerNo) {
    this.customerNo = customerNo;
    return this;
  }

  /**
   * 用户ID下发数据需要,由属地直接传过来
   * @return customerNo
   **/
  @ApiModelProperty(value = "用户ID下发数据需要,由属地直接传过来")
  public String getCustomerNo() {
    return customerNo;
  }

  public void setCustomerNo(String customerNo) {
    this.customerNo = customerNo;
  }

  @JsonIgnore
  public SellerInvoiceInfo invoiceUrl(String invoiceUrl) {
    this.invoiceUrl = invoiceUrl;
    return this;
  }

  /**
   * 发票影像的URL
   * @return invoiceUrl
   **/
  @ApiModelProperty(value = "发票影像的URL")
  public String getInvoiceUrl() {
    return invoiceUrl;
  }

  public void setInvoiceUrl(String invoiceUrl) {
    this.invoiceUrl = invoiceUrl;
  }


  @JsonIgnore
  public SellerInvoiceInfo ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

   /**
   * ext1
   * @return ext1
  **/
  @ApiModelProperty(value = "ext1")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

   /**
   * ext2
   * @return ext2
  **/
  @ApiModelProperty(value = "ext2")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext3(String ext3) {
    this.ext3 = ext3;
    return this;
  }

   /**
   * ext3
   * @return ext3
  **/
  @ApiModelProperty(value = "ext3")
  public String getExt3() {
    return ext3;
  }

  public void setExt3(String ext3) {
    this.ext3 = ext3;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext4(String ext4) {
    this.ext4 = ext4;
    return this;
  }

   /**
   * ext4
   * @return ext4
  **/
  @ApiModelProperty(value = "ext4")
  public String getExt4() {
    return ext4;
  }

  public void setExt4(String ext4) {
    this.ext4 = ext4;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext5(String ext5) {
    this.ext5 = ext5;
    return this;
  }

   /**
   * ext5
   * @return ext5
  **/
  @ApiModelProperty(value = "ext5")
  public String getExt5() {
    return ext5;
  }

  public void setExt5(String ext5) {
    this.ext5 = ext5;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext6(String ext6) {
    this.ext6 = ext6;
    return this;
  }

   /**
   * ext6
   * @return ext6
  **/
  @ApiModelProperty(value = "ext6")
  public String getExt6() {
    return ext6;
  }

  public void setExt6(String ext6) {
    this.ext6 = ext6;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext7(String ext7) {
    this.ext7 = ext7;
    return this;
  }

   /**
   * ext7
   * @return ext7
  **/
  @ApiModelProperty(value = "ext7")
  public String getExt7() {
    return ext7;
  }

  public void setExt7(String ext7) {
    this.ext7 = ext7;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext8(String ext8) {
    this.ext8 = ext8;
    return this;
  }

   /**
   * ext8
   * @return ext8
  **/
  @ApiModelProperty(value = "ext8")
  public String getExt8() {
    return ext8;
  }

  public void setExt8(String ext8) {
    this.ext8 = ext8;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext9(String ext9) {
    this.ext9 = ext9;
    return this;
  }

   /**
   * ext9
   * @return ext9
  **/
  @ApiModelProperty(value = "ext9")
  public String getExt9() {
    return ext9;
  }

  public void setExt9(String ext9) {
    this.ext9 = ext9;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext10(String ext10) {
    this.ext10 = ext10;
    return this;
  }

   /**
   * ext10
   * @return ext10
  **/
  @ApiModelProperty(value = "ext10")
  public String getExt10() {
    return ext10;
  }

  public void setExt10(String ext10) {
    this.ext10 = ext10;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext11(String ext11) {
    this.ext11 = ext11;
    return this;
  }

   /**
   * ext11
   * @return ext11
  **/
  @ApiModelProperty(value = "ext11")
  public String getExt11() {
    return ext11;
  }

  public void setExt11(String ext11) {
    this.ext11 = ext11;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext12(String ext12) {
    this.ext12 = ext12;
    return this;
  }

   /**
   * ext12
   * @return ext12
  **/
  @ApiModelProperty(value = "ext12")
  public String getExt12() {
    return ext12;
  }

  public void setExt12(String ext12) {
    this.ext12 = ext12;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext13(String ext13) {
    this.ext13 = ext13;
    return this;
  }

   /**
   * ext13
   * @return ext13
  **/
  @ApiModelProperty(value = "ext13")
  public String getExt13() {
    return ext13;
  }

  public void setExt13(String ext13) {
    this.ext13 = ext13;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext14(String ext14) {
    this.ext14 = ext14;
    return this;
  }

   /**
   * ext14
   * @return ext14
  **/
  @ApiModelProperty(value = "ext14")
  public String getExt14() {
    return ext14;
  }

  public void setExt14(String ext14) {
    this.ext14 = ext14;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext15(String ext15) {
    this.ext15 = ext15;
    return this;
  }

   /**
   * ext15
   * @return ext15
  **/
  @ApiModelProperty(value = "ext15")
  public String getExt15() {
    return ext15;
  }

  public void setExt15(String ext15) {
    this.ext15 = ext15;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext16(String ext16) {
    this.ext16 = ext16;
    return this;
  }

   /**
   * ext16
   * @return ext16
  **/
  @ApiModelProperty(value = "ext16")
  public String getExt16() {
    return ext16;
  }

  public void setExt16(String ext16) {
    this.ext16 = ext16;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext17(String ext17) {
    this.ext17 = ext17;
    return this;
  }

   /**
   * ext17
   * @return ext17
  **/
  @ApiModelProperty(value = "ext17")
  public String getExt17() {
    return ext17;
  }

  public void setExt17(String ext17) {
    this.ext17 = ext17;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext18(String ext18) {
    this.ext18 = ext18;
    return this;
  }

   /**
   * ext18
   * @return ext18
  **/
  @ApiModelProperty(value = "ext18")
  public String getExt18() {
    return ext18;
  }

  public void setExt18(String ext18) {
    this.ext18 = ext18;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext19(String ext19) {
    this.ext19 = ext19;
    return this;
  }

   /**
   * ext19
   * @return ext19
  **/
  @ApiModelProperty(value = "ext19")
  public String getExt19() {
    return ext19;
  }

  public void setExt19(String ext19) {
    this.ext19 = ext19;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext20(String ext20) {
    this.ext20 = ext20;
    return this;
  }

   /**
   * ext20
   * @return ext20
  **/
  @ApiModelProperty(value = "ext20")
  public String getExt20() {
    return ext20;
  }

  public void setExt20(String ext20) {
    this.ext20 = ext20;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext21(String ext21) {
    this.ext21 = ext21;
    return this;
  }

   /**
   * ext21
   * @return ext21
  **/
  @ApiModelProperty(value = "ext21")
  public String getExt21() {
    return ext21;
  }

  public void setExt21(String ext21) {
    this.ext21 = ext21;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext22(String ext22) {
    this.ext22 = ext22;
    return this;
  }

   /**
   * ext22
   * @return ext22
  **/
  @ApiModelProperty(value = "ext22")
  public String getExt22() {
    return ext22;
  }

  public void setExt22(String ext22) {
    this.ext22 = ext22;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext23(String ext23) {
    this.ext23 = ext23;
    return this;
  }

   /**
   * ext23
   * @return ext23
  **/
  @ApiModelProperty(value = "ext23")
  public String getExt23() {
    return ext23;
  }

  public void setExt23(String ext23) {
    this.ext23 = ext23;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext24(String ext24) {
    this.ext24 = ext24;
    return this;
  }

   /**
   * ext24
   * @return ext24
  **/
  @ApiModelProperty(value = "ext24")
  public String getExt24() {
    return ext24;
  }

  public void setExt24(String ext24) {
    this.ext24 = ext24;
  }

  @JsonIgnore
  public SellerInvoiceInfo ext25(String ext25) {
    this.ext25 = ext25;
    return this;
  }

   /**
   * ext25
   * @return ext25
  **/
  @ApiModelProperty(value = "ext25")
  public String getExt25() {
    return ext25;
  }

  public void setExt25(String ext25) {
    this.ext25 = ext25;
  }

  /**
   * 销方组织id
   * @return sellerId
   **/
  @ApiModelProperty(value = "sellerId")
  public Long getSellerId() {
    return sellerId;
  }

  public void setSellerId(Long sellerId) {
    this.sellerId = sellerId;
  }
  /**
   * 作废标识 0-默认 1-批次内 2-批次外
   * @return abandonFlag
   **/
  @ApiModelProperty(value = "abandonFlag")
  public String getAbandonFlag() {
    return abandonFlag;
  }

  public void setAbandonFlag(String abandonFlag) {
    this.abandonFlag = abandonFlag;
  }
  /**
   * 接收人邮箱
   * @return receiveUserEmail
   **/
  @ApiModelProperty(value = "receiveUserEmail")
  public String getReceiveUserEmail() {
    return receiveUserEmail;
  }

  public void setReceiveUserEmail(String receiveUserEmail) {
    this.receiveUserEmail = receiveUserEmail;
  }
  /**
   * 外部批次生成标志 1-不生成 0-生成
   * @return outCheckStatus
   **/
  @ApiModelProperty(value = "outCheckStatus")
  public String getOutCheckStatus() {
    return outCheckStatus;
  }

  public void setOutCheckStatus(String outCheckStatus) {
    this.outCheckStatus = outCheckStatus;
  }

  /**
   * 权限ID
   * @return sysOrgId
   **/
  @ApiModelProperty(value = "sysOrgId")
  public Long getSysOrgId() {
    return sysOrgId;
  }

  public void setSysOrgId(Long sysOrgId) {
    this.sysOrgId = sysOrgId;
  }

  /**
   * 组织名称
   * @return sysOrgName
   **/
  @ApiModelProperty(value = "sysOrgName")
  public String getSysOrgName() {
    return sysOrgName;
  }

  public void setSysOrgName(String sysOrgName) {
    this.sysOrgName = sysOrgName;
  }


  @JsonIgnore
  public SellerInvoiceInfo addressee(String addressee) {
    this.addressee = addressee;
    return this;
  }

  public String getAddressee() {
    return addressee;
  }

  public void setAddressee(String addressee) {
    this.addressee = addressee;
  }

  @JsonIgnore
  public SellerInvoiceInfo addresseeTel(String addresseeTel) {
    this.addresseeTel = addresseeTel;
    return this;
  }

  public String getAddresseeTel() {
    return addresseeTel;
  }

  public void setAddresseeTel(String addresseeTel) {
    this.addresseeTel = addresseeTel;
  }

  @JsonIgnore
  public SellerInvoiceInfo addresseeProvince(String addresseeProvince) {
    this.addresseeProvince = addresseeProvince;
    return this;
  }

  public String getAddresseeProvince() {
    return addresseeProvince;
  }

  public void setAddresseeProvince(String addresseeProvince) {
    this.addresseeProvince = addresseeProvince;
  }

  @JsonIgnore
  public SellerInvoiceInfo addresseeCity(String addresseeCity) {
    this.addresseeCity = addresseeCity;
    return this;
  }

  public String getAddresseeCity() {
    return addresseeCity;
  }

  public void setAddresseeCity(String addresseeCity) {
    this.addresseeCity = addresseeCity;
  }

  @JsonIgnore
  public SellerInvoiceInfo addresseeCounty(String addresseeCounty) {
    this.addresseeCounty = addresseeCounty;
    return this;
  }

  public String getAddresseeCounty() {
    return addresseeCounty;
  }

  public void setAddresseeCounty(String addresseeCounty) {
    this.addresseeCounty = addresseeCounty;
  }

  @JsonIgnore
  public SellerInvoiceInfo direction(String direction) {
    this.direction = direction;
    return this;
  }
  public String getDirection() {
    return direction;
  }

  public void setDirection(String direction) {
    this.direction = direction;
  }

  @JsonIgnore
  public SellerInvoiceInfo logisticRemark(String logisticRemark) {
    this.logisticRemark = logisticRemark;
    return this;
  }
  public String getLogisticRemark() {
    return logisticRemark;
  }

  public void setLogisticRemark(String logisticRemark) {
    this.logisticRemark = logisticRemark;
  }

  @JsonIgnore
  public SellerInvoiceInfo addresseeComp(String addresseeComp) {
    this.addresseeComp = addresseeComp;
    return this;
  }
  public String getAddresseeComp() {
    return addresseeComp;
  }

  public void setAddresseeComp(String addresseeComp) {
    this.addresseeComp = addresseeComp;
  }

  @JsonIgnore
  public SellerInvoiceInfo addresseePost(String addresseePost) {
    this.addresseePost = addresseePost;
    return this;
  }

  public String getAddresseePost() {
    return addresseePost;
  }

  public void setAddresseePost(String addresseePost) {
    this.addresseePost = addresseePost;
  }

  public Integer getAuditType() {
    return auditType;
  }

  public void setAuditType(Integer auditType) {
    this.auditType = auditType;
  }

  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  public String getOrderNos() {
    return orderNos;
  }

  public void setOrderNos(String orderNos) {
    this.orderNos = orderNos;
  }

  public String getSellerBankInfo() {
    return sellerBankInfo;
  }

  public void setSellerBankInfo(String sellerBankInfo) {
    this.sellerBankInfo = sellerBankInfo;
  }

  public String getSellerAddrTel() {
    return sellerAddrTel;
  }

  public void setSellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
  }

  public String getPurchaserBankInfo() {
    return purchaserBankInfo;
  }

  public void setPurchaserBankInfo(String purchaserBankInfo) {
    this.purchaserBankInfo = purchaserBankInfo;
  }

  public String getPurchaserAddrTel() {
    return purchaserAddrTel;
  }

  public void setPurchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
  }

  public String getInvoiceKind() {
    return invoiceKind;
  }

  public void setInvoiceKind(String invoiceKind) {
    this.invoiceKind = invoiceKind;
  }

  public String getTaxInvoiceSource() {
    return taxInvoiceSource;
  }

  public void setTaxInvoiceSource(String taxInvoiceSource) {
    this.taxInvoiceSource = taxInvoiceSource;
  }

  public String getOriginPaperDrawDate() {
    return originPaperDrawDate;
  }

  public void setOriginPaperDrawDate(String originPaperDrawDate) {
    this.originPaperDrawDate = originPaperDrawDate;
  }

  public Integer getMakeType() {
    return makeType;
  }

  public void setMakeType(Integer makeType) {
    this.makeType = makeType;
  }

  public String getOriginInvoiceType() {
    return originInvoiceType;
  }

  public void setOriginInvoiceType(String originInvoiceType) {
    this.originInvoiceType = originInvoiceType;
  }

  public String getRedUserName() {
    return redUserName;
  }

  public void setRedUserName(String redUserName) {
    this.redUserName = redUserName;
  }

  public String getReceiveUserTel() {
    return receiveUserTel;
  }

  public void setReceiveUserTel(String receiveUserTel) {
    this.receiveUserTel = receiveUserTel;
  }

  public String getChannel() {
    return channel;
  }

  public void setChannel(String channel) {
    this.channel = channel;
  }

  public String getAllElectricInvoiceNo() {
    return allElectricInvoiceNo;
  }

  public void setAllElectricInvoiceNo(String allElectricInvoiceNo) {
    this.allElectricInvoiceNo = allElectricInvoiceNo;
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
