package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * TerminalInfo
 */

@JsonInclude(NON_NULL)
public class TerminalInfo {
    @JsonProperty("terminalId")
    private Long terminalId = null;

    @JsonProperty("terminalName")
    private String terminalName = null;

    @ApiModelProperty(value = "设备id")
    private String deviceId;

    @ApiModelProperty(value = "开票模式, 1=单盘，2=服务器")
    private String terminalType;

    @JsonProperty("directOnlineFlag")
    private Integer directOnlineFlag;

    @JsonProperty("printerOnlineFlag")
    private Integer printerOnlineFlag;

    @ApiModelProperty(value = "设备唯一编码")
    private String deviceUn;
    @ApiModelProperty(value = "终端唯一编码")
    private String terminalUn;
    @ApiModelProperty(value = "库存数量")
    private Integer inventory;
    @ApiModelProperty("设备类型")
    private Integer taxDeviceType;
    @ApiModelProperty("机器编码")
    private String taxDeviceMachineNo;
    @ApiModelProperty("部署类型")
    private Integer deployType;

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }
    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }

    public void setTaxDeviceType(Integer taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public Integer getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
    }

    public String getTaxDeviceMachineNo() {
        return taxDeviceMachineNo;
    }

    @JsonIgnore
    public TerminalInfo terminalId(Long terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    /**
     * 开票终端id
     *
     * @return terminalId
     **/
    @ApiModelProperty(value = "开票终端id")
    public Long getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(Long terminalId) {
        this.terminalId = terminalId;
    }

    @JsonIgnore
    public TerminalInfo terminalName(String terminalName) {
        this.terminalName = terminalName;
        return this;
    }

    /**
     * 开票终端名称
     *
     * @return terminalName
     **/
    @ApiModelProperty(value = "开票终端名称")
    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalInfo terminalInfo = (TerminalInfo) o;
        return Objects.equals(this.terminalId, terminalInfo.terminalId)
                && Objects.equals(this.terminalName, terminalInfo.terminalName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(terminalId, terminalName);
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    public Integer getDirectOnlineFlag() {
        return directOnlineFlag;
    }

    public void setDirectOnlineFlag(Integer directOnlineFlag) {
        this.directOnlineFlag = directOnlineFlag;
    }

    public Integer getPrinterOnlineFlag() {
        return printerOnlineFlag;
    }

    public void setPrinterOnlineFlag(Integer printerOnlineFlag) {
        this.printerOnlineFlag = printerOnlineFlag;
    }

    public Integer getInventory() {
        return inventory;
    }

    public void setInventory(Integer inventory) {
        this.inventory = inventory;
    }

    public Integer getDeployType() {
        return deployType;
    }

    public void setDeployType(Integer deployType) {
        this.deployType = deployType;
    }

    @Override
    public String toString() {
        return "TerminalInfo{" + "terminalId=" + terminalId + ", terminalName='" + terminalName + '\'' + ", deviceId='"
                + deviceId + '\'' + ", terminalType='" + terminalType + '\'' + ", directOnlineFlag=" + directOnlineFlag
                + ", printerOnlineFlag=" + printerOnlineFlag + ", inventory=" + inventory + '}';
    }
}
