package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 用户权限下的设备号信息
 */
@Getter
@Setter
@JsonInclude(NON_NULL)
public class UserOfTerminalUnsResponse<T> {

    /**
     * 实体
     */
    @JsonProperty("msTerminalQueryResponse")
    private List<T> msTerminalQueryResponse;
    /**
     * 组织id
     */
    @ApiModelProperty("组织id")
    private Long orgId;

    /**
     * 组织类型
     */
    @ApiModelProperty("组织类型")
    private Integer orgType;
    /**
     * 组织代码
     */
    @ApiModelProperty("组织代码")
    private String orgCode;
    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;
    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private Long companyId;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String companyName;
    @ApiModelProperty("公司代码")
    /**
     * 公司代码
     */
    private String companyCode;
    @ApiModelProperty("公司编号集合")
    /**
     * 公司编号集合
     */
    private List companyNos;
    @ApiModelProperty("税号")
    /**
     * 税号
     */
    private String taxNum;
    @ApiModelProperty("租户id")
    /**
     * 租户id
     */
    private Long tenantId;
    @ApiModelProperty("租户名称")
    /**
     * 租户名称
     */
    private String tenantName;
    @ApiModelProperty("租户代码")
    /**
     * 租户代码
     */
    private String tenantCode;

}
