package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("分页对象")
public class DataList<T> {
    @ApiModelProperty("返回对象集合")
    private List<T> data;
    @ApiModelProperty("数据总量")
    private Integer total;
    @ApiModelProperty("每页大小")
    private Integer pageSize;
    @ApiModelProperty("当页页码")
    private Integer pageNo;
}
