package com.xforceplus.seller.invoice.client.model.open;

import lombok.Data;

/**
 * 根据 发票、号码(对应发票信息生成预制发票）红冲发票
 */
@Data
public class OpenIssueHCRequest {
    /**
     * 发票号码
     */
    private String invoiceNo;
    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 释放类型 1-释放预制发票 2-释放业务单 3-不释放预制发票或业务单 4-释放业务单[释放业务单 但是 不释放 明细（抽取已匹配业务单的发票 释放情况）]
     */
    private Integer releaseType;
    /**
     * 红字编号
     */
    private String redNotificationNo;
    /**
     * 开票终端
     */
    private String terminalCode ;
    /**
     * 开具原因 参考枚举 MakingReason
     */
    private String makingReason;
    /**
     * 原因
     */
    private String reason;

}
