package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("购方信息")
public class QueryBuyer {
    @ApiModelProperty("购方集团Id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long buyerGroupId;
    @ApiModelProperty("购方公司Id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long buyerId;
    @ApiModelProperty("购方公司编号")
    private String buyerNo;
    @ApiModelProperty("购方名称")
    private String buyerName;
    @ApiModelProperty("购方税号")
    private String buyerTaxNo;
    @ApiModelProperty("购方电话")
    private String buyerTel;
    @ApiModelProperty("购方地址")
    private String buyerAddress;
    @ApiModelProperty("购方银行名称")
    private String buyerBankName;
    @ApiModelProperty("购方银行名称")
    private String buyerBankAccount;
}
