package com.xforceplus.seller.invoice.client.model.open.v2.invoice;

import com.xforceplus.seller.invoice.client.model.open.v2.pre.DetailExtendedAttrs;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

@Data
@NoArgsConstructor
@ToString
public class InvoiceDetail {
    @ApiModelProperty("发票明细id")
    private String invoiceDetailId;
    @ApiModelProperty("invoiceId")
    private String invoiceId;

    @ApiModelProperty("预制发票id")
    private String preInvoiceId;

    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("规格型号")
    private String specifications;
    @ApiModelProperty("数量单位")
    private String unit;

    @ApiModelProperty("数量")
    private String quantity;
    @ApiModelProperty("单价")
    private String unitPrice;
    @ApiModelProperty("税率")
    private String taxRate;


    @ApiModelProperty("含税金额")
    private String amountWithTax;

    @ApiModelProperty("不含税金额")
    private String amountWithoutTax;

    @ApiModelProperty("税额")
    private String taxAmount;

    @ApiModelProperty("扣除额")
    private String deduction;


    @ApiModelProperty("折扣不含税金额")
    private String discountAmountWithoutTax;

    @ApiModelProperty("折扣税额")
    private String discountTaxAmount;

    @ApiModelProperty("折扣含税金额")
    private String discountAmountWithTax;

    @ApiModelProperty("税编版本")
    private String goodsTaxNoVersion;

    @ApiModelProperty("税收分类编码")
    private String goodsTaxNo;

    @ApiModelProperty("是否享受税收优惠政策")
    private String taxPre;

    @ApiModelProperty("享受税收优惠政策内容")
    private String taxPreCon;
    @ApiModelProperty("零税率标志")
    private String zeroTax;

    @ApiModelProperty("创建时间 ")
    private String createTime;

    @ApiModelProperty("更新时间")
    private String updateTime;


    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("土地增值税项目编号")
    private String landVatItemNo = null;

    @ApiModelProperty("跨地市标志")
    private String crossCitySign = null;

    @ApiModelProperty("发生详细地址")
    private String placeOfOccurrence = null;

    @ApiModelProperty("建筑项目名称")
    private String entryName = null;

    @ApiModelProperty("建筑服务发生地")
    private String place = null;

    @ApiModelProperty("运输工具种类")
    private String toolType = null;

    @ApiModelProperty("运输工具牌号")
    private String toolBrand = null;

    @ApiModelProperty("运输货物名称")
    private String nameOfGoods = null;

    @ApiModelProperty("起运地")
    private String placeOfShipment = null;

    @ApiModelProperty("到达地")
    private String destination = null;

    @ApiModelProperty("不动产详细地址")
    private String realEstateAddress = null;

    @ApiModelProperty("不动产单元代码/网签合同备案编码")
    private String realEstateCode = null;

    @ApiModelProperty("核定计税价格")
    private String taxablePrice = null;

    @ApiModelProperty("实际成交含税金额")
    private String transactionPrice = null;

    @ApiModelProperty("不动产地址（省市区）")
    private String realEstatePlace = null;

    @ApiModelProperty("房屋产权证书/不动产权证号码")
    private String realEstateNo = null;

    @ApiModelProperty("面积单位")
    private String areaUnit = null;

    // 不动产租赁
    @ApiModelProperty("租赁期起")
    private String leaseTermStart = null;

    @ApiModelProperty("租赁期止")
    private String leaseTermEnd = null;

    @ApiModelProperty("明细扩展")
    private DetailExtendedAttrs detailExtendedAttrs;


}
