package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "invoice", description = "the invoice API")
public interface InvoiceApi {

    @ApiOperation(value = "发票 - 查询发票详情", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/getInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getSellerInvoice(@ApiParam(value = "发票号码和代码", required = true) @RequestBody MsQueryInvoiceRequest request);

    @ApiOperation(value = "作废 - 通用校验接口", notes = "", response = AbandonInvoiceCheckResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "打印校验通用接口返回", response = AbandonInvoiceCheckResponse.class) })
    @RequestMapping(value = "/invoice/abandonInvoiceCheck",
            produces = { "application/json" },
            method = RequestMethod.POST)
    AbandonInvoiceCheckResponse abandonInvoiceCheck(@ApiParam(value = "打印发票号列表", required = true) @RequestBody AbandonInvoiceCheckRequest abandonInvoiceCheckRequest);

    @ApiOperation(value = "发票作废 - 按照发票号作废", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/abandonInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse abandonInvoice(@ApiParam(value = "废弃发票id列表", required = true) @RequestBody AbandonSellerInvoiceRequest abandonSellerInvoiceRequest);

    @ApiOperation(value = "发票作废 - 轮训结果接口", notes = "", response = PollingAbandonInvoiceResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingAbandonInvoiceResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingAbandonInvoiceResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingAbandonInvoiceResultResponse pollingAbandonInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);

    @ApiOperation(value = "发票 - 申请退票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/applyRefund",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response applyRefund(@ApiParam(value = "申请退票", required = true) @RequestBody ApplyRefundRequest applyRefundRequest);


    @ApiOperation(value = "发票 - pdf生成（含销货清单）", notes = "", response = ExportInvoicePDFResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = ExportInvoicePDFResponse.class) })
    @RequestMapping(value = "invoice/exportInvoicePDF",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ExportInvoicePDFResponse exportInvoicePDF(@ApiParam(value = "导出发票（或含销货清单）pdf", required = true) @RequestBody ExportInvoicePDFRequest exportInvoicePDFRequest);


    @ApiOperation(value = "发票 - pdf生成（含销货清单）", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "invoice/generatePDF",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response generatePDF(@ApiParam(value = "发票pdf生成（含销货清单）", required = true) @RequestBody InvoiceGeneratePDFRequest invoiceGeneratePDFRequest);


    @ApiOperation(value = "发票 - 锁定", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/lockInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response lockInvoice(@ApiParam(value = "锁定", required = true) @RequestBody LockInvoiceRequest lockInvoiceRequest);

    @ApiOperation(value = "发票 - 根据id列表锁定", notes = "", response = LockInvoiceByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = LockInvoiceByIdsResponse.class) })
    @RequestMapping(value = "/invoice/lockInvoicesByIds",
            produces = { "application/json" },
            method = RequestMethod.POST)
    LockInvoiceByIdsResponse lockInvoicesByIds(@ApiParam(value = "根据id列表锁定", required = true) @RequestBody LockInvoiceByIdsRequest lockInvoiceByIdsRequest);


    @ApiOperation(value = "发票 - 根据发票号码代码锁定", notes = "", response = LockInvoiceByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = LockInvoiceByIdsResponse.class) })
    @RequestMapping(value = "/invoice/lockInvoicesByApi",
            produces = { "application/json" },
            method = RequestMethod.POST)
    LockInvoiceByCodeResponse lockInvoicesByApi(@ApiParam(value = "根据发票号码代码锁定", required = true) @RequestBody ApiLockInvoiceRequest apiLockInvoiceRequest);


    @ApiOperation(value = "发票 - 根据发票号码代码锁定", notes = "", response = LockInvoiceByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = LockInvoiceByIdsResponse.class) })
    @RequestMapping(value = "/invoice/unLockInvoicesByApi",
            produces = { "application/json" },
            method = RequestMethod.POST)
    UnLockInvoiceByCodeResponse unLockInvoicesByApi(@ApiParam(value = "根据发票号码代码锁定", required = true) @RequestBody ApiUnLockInvoiceRequest apiUnLockInvoiceRequest);



    @ApiOperation(value = "发票 - 外部审核状态", notes = "", response = OutBatchNoFlagResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = OutBatchNoFlagResponse.class) })
    @RequestMapping(value = "/invoice/outCheckInvoicesByIds",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OutBatchNoFlagResponse outCheckInvoicesByIds(@ApiParam(value = "外部审核状态", required = true) @RequestBody OutCheckInvoicesByIdsRequest outCheckInvoicesByIdsRequest);

    @ApiOperation(value = "发票打印-基础接口", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/basePrintInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse basePrintInvoice(@ApiParam(value = "打印发票号列表", required = true) @RequestBody BasePrintSellerInvoiceRequest basePrintSellerInvoiceRequest);

    @ApiOperation(value = "发票基础打印-轮询接口", notes = "", response = PollingBasePrintInvoiceResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingBasePrintInvoiceResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingBasePrintInvoiceResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingBasePrintInvoiceResultResponse pollingBasePrintInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);


    @ApiOperation(value = "打印发票或销货清单接口", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/printInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse printInvoice(@ApiParam(value = "打印发票号列表", required = true) @RequestBody PrintSellerInvoiceRequest printSellerInvoiceRequest);

    @ApiOperation(value = "打印发票或销货清单--轮训结果接口", notes = "", response = PollingPrintInvoiceResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingPrintInvoiceResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingPrintInvoiceResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingPrintInvoiceResultResponse pollingPrintInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);

    @ApiOperation(value = "打印 - 通用校验接口", notes = "", response = PrintSellerInvoiceCheckResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "打印校验通用接口返回", response = PrintSellerInvoiceCheckResponse.class) })
    @RequestMapping(value = "/invoice/printInvoiceCheck",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PrintSellerInvoiceCheckResponse printInvoiceCheck(@ApiParam(value = "打印发票号列表", required = true) @RequestBody PrintSellerInvoiceCheckRequest printSellerInvoiceCheckRequest);


    @ApiOperation(value = "发票 - 打印销货清单", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/printSaleList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse printSaleList(@ApiParam(value = "打印销货清单", required = true) @RequestBody PrintSaleListRequest printSaleListRequest);

    @ApiOperation(value = "发票 - 打印销货清单轮训接口", notes = "", response = PollingPrintSellListResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingPrintSellListResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingPrintSaleListResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingPrintSellListResultResponse pollingPrintSaleListResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);

    @ApiOperation(value = "查询发票对应的单据的明细信息", notes = "", response = QueryBillDetailsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "单据明细查询返回", response = QueryBillDetailsResponse.class) })
    @RequestMapping(value = "/invoice/queryBillDetails",
            produces = { "application/json" },
            method = RequestMethod.POST)
    QueryBillDetailsResponse queryBillDetails(@ApiParam(value = "单据id", required = true) @RequestBody QueryBillDetailsRequest queryBillDetailsRequest);


    @ApiOperation(value = "发票管理 - 获取邮箱列表", notes = "", response = QueryEmailBoxListResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "邮箱查询返回", response = QueryEmailBoxListResponse.class) })
    @RequestMapping(value = "invoice/queryEmailBoxList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    QueryEmailBoxListResponse queryEmailBoxList(@ApiParam(value = "获取邮箱列表", required = true) @RequestBody QueryEmailBoxListRequest queryEmailBoxListRequest);


    @ApiOperation(value = "发票查询", notes = "", response = SellerInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SellerInvoiceQueryResponse queryInvoice(@ApiParam(value = "发票查询请求") @RequestBody SellerInvoiceQueryByConditionRequest sellerInvoiceQueryByConditionRequest);


    @ApiOperation(value = "发票详情-包含发票信息、发票明细信息列表、发票操作日志列表", notes = "", response = InvoiceDetailsInfoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = InvoiceDetailsInfoResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoiceDetailsById",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvoiceDetailsInfoResponse queryInvoiceDetailsById(@ApiParam(value = "发票id", required = true) @RequestBody QuerySellerInvoiceDetailsRequest querySellerInvoiceDetailsRequest);

    @ApiOperation(value = "发票红冲 - 发票红冲", notes = "", response = RedflushSellerInvoiceCheckResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = RedflushSellerInvoiceCheckResponse.class) })
    @RequestMapping(value = "/invoice/redFlushInvoiceCheck",
            produces = { "application/json" },
            method = RequestMethod.POST)
    RedflushSellerInvoiceCheckResponse redFlushInvoiceCheck(@ApiParam(value = "红冲发票号列表", required = true) @RequestBody RedflushSellerInvoiceCheckRequest redflushSellerInvoiceRequest);


    @ApiOperation(value = "发票红冲 - 发票红冲", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/redFlushInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse redFlushInvoice(@ApiParam(value = "红冲发票号列表", required = true) @RequestBody RedflushSellerInvoiceRequest redflushSellerInvoiceRequest);

    @ApiOperation(value = "发票红冲 - 轮训结果", notes = "", response = PollingRedFlushInvoiceResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingRedFlushInvoiceResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingRedFlushInvoiceResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingRedFlushInvoiceResultResponse pollingRedFlushInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);

    @ApiOperation(value = "发票 - 驳回", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/reject",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response reject(@ApiParam(value = "驳回", required = true) @RequestBody RejectRequest rejectRequest);


    @ApiOperation(value = "发票 - 发送电票邮件", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "invoice/sendEinvoiceEmail",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse sendEinvoiceEmail(@ApiParam(value = "发送电票邮件", required = true) @RequestBody SendEinvoiceEmailRequest sendEinvoiceEmailRequest);


    @ApiOperation(value = "查询发票对应的单据列表", notes = "", response = ShowInvoiceBillsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "单据列表查询返回", response = ShowInvoiceBillsResponse.class) })
    @RequestMapping(value = "/invoice/showInvoiceBills",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ShowInvoiceBillsResponse showInvoiceBills(@ApiParam(value = "发票id", required = true) @RequestBody ShowInvoiceBillsRequest showInvoiceBillsRequest);


    @ApiOperation(value = "发票 - 查看历史", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/showInvoiceHistory",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response showInvoiceHistory(@ApiParam(value = "查看历史", required = true) @RequestBody ShowInvoiceHistoryRequest showInvoiceHistoryRequest);


    @ApiOperation(value = "发票 - 解锁", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/unlockInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response unlockInvoice(@ApiParam(value = "解锁", required = true) @RequestBody UnlockInvoiceRequest unlockInvoiceRequest);

    @ApiOperation(value = "发票批次号查询", notes = "", response = InvoiceBatchNosQueryByConditionResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票批次号查询返回", response = InvoiceBatchNosQueryByConditionResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoiceBatchNos",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvoiceBatchNosQueryByConditionResponse queryInvoiceBatchNos(InvoiceBatchNosQueryByConditionRequest invoiceBatchNosQueryByConditionRequest);

    @ApiOperation(value = "发票列表查询-按批次号", notes = "", response = SellerInvoiceQueryByBatchNoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryByBatchNoResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoicesByBatchNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SellerInvoiceQueryByBatchNoResponse queryInvoicesByBatchNo(@ApiParam(value = "发票查询请求") @RequestBody SellerInvoiceQueryByBatchNoRequest sellerInvoiceQueryByBatchNoRequest);


    @ApiOperation(value = "发票 - 查看一个批次号下所有操作日志", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/showInvoiceHistoryByBatchNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response showInvoiceHistoryByBatchNo(@ApiParam(value = "查看历史日志", required = true) @RequestBody ShowInvoiceHistoryByBatchNoRequest showInvoiceHistoryByBatchNoRequest);

    @ApiOperation(value = "统计在线开票数量", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/queryOnlineSum",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryOnlineSumRequest(@ApiParam(value = "查询在线开票数量", required = true) @RequestBody QueryOnlineSumRequest queryOnlineSumRequest);


    @ApiOperation(value = "申请红字信息表编号", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/applyRedInfoNoForInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response applyRedInfoNoForInvoice(@ApiParam(value = "发票申请红字信息表编号请求", required = true) @RequestBody ApplyRedNotifucationRequest applyRedNotifucationRequest);


}
