package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;


@Api(value = "redNotification", description = "the redNotification API")
public interface RedNotificationApi {
    @ApiOperation(
            value = "获取PDF的URL",
            notes = "----获取PDF的URL----",
            response = PdfUrlResponse.class,
            authorizations = {@Authorization("X-Access-Token"), @Authorization("X-Operation-Token")},
            tags = {"redNotification"}
    )
    @ApiResponses({@ApiResponse(
            code = 200,
            message = "response",
            response = PdfUrlResponse.class
    )})
    @RequestMapping(
            value = {"/redNotification/getPdfUrl"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    PdfUrlResponse getPdfUrl(@RequestBody PdfUrlRequest var1);

    @ApiOperation(value = "预制发票申请接口", notes = "", response = MsApplyForRedNoResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsApplyForRedNoResponse.class) })
    @RequestMapping(value = "/redNotification/applyForRedNo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsApplyForRedNoResponse applyForRedNo(@ApiParam(value = "request", required = true) @RequestBody RedNoApplyRequest id);


    @ApiOperation(value = "删除业务单所有红字信息", notes = "", response = MsDeleteBillRedNoAllResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsDeleteBillRedNoAllResponse.class) })
    @RequestMapping(value = "/redNotification/deleteBillRedNoAll",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsDeleteBillRedNoAllResponse deleteBillRedNoAll(@ApiParam(value = "request", required = true) @RequestBody MsDeleteBillRedNoAllRequest id);


    @ApiOperation(value = "删除所有红字信息", notes = "", response = MsDeleteRedNoAllResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsDeleteRedNoAllResponse.class) })
    @RequestMapping(value = "/redNotification/deleteRedNoAll",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsDeleteRedNoAllResponse deleteRedNoAll(@ApiParam(value = "request", required = true) @RequestBody MsDeleteRedNoAllRequest id);


    @ApiOperation(value = "编辑红字信息详情", notes = "", response = MsEditRedNoDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsEditRedNoDetailResponse.class) })
    @RequestMapping(value = "/redNotification/editRedNoDetail",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsEditRedNoDetailResponse editRedNoDetail(@ApiParam(value = "request", required = true) @RequestBody MsEditRedNoDetailRequest id);


    @ApiOperation(value = "导出业务单所有红字信息", notes = "", response = MsExportBillRedNoAllResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsExportBillRedNoAllResponse.class) })
    @RequestMapping(value = "/redNotification/exportBillRedNoAll",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsExportBillRedNoAllResponse exportBillRedNoAll(@ApiParam(value = "request", required = true) @RequestBody MsExportBillRedNoAllRequest id);


    @ApiOperation(value = "导出所有红字信息", notes = "", response = MsExportRedNoAllResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsExportRedNoAllResponse.class) })
    @RequestMapping(value = "/redNotification/exportRedNoAll",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsExportRedNoAllResponse exportRedNoAll(@ApiParam(value = "request", required = true) @RequestBody MsExportRedNoAllRequest id);


    @ApiOperation(value = "业务单所有红字信息终端", notes = "", response = MakeOutBeforeConfirmedResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MakeOutBeforeConfirmedResponse.class) })
    @RequestMapping(value = "/redNotification/getBillRedNoTerminal",
        produces = { "application/json" },
        method = RequestMethod.POST)
    MakeOutBeforeConfirmedResponse getBillRedNoTerminal(@ApiParam(value = "request", required = true) @RequestBody MsGetBillRedNoTerminalRequest id);


    @ApiOperation(value = "所有红字信息终端", notes = "", response = MakeOutBeforeConfirmedResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MakeOutBeforeConfirmedResponse.class) })
    @RequestMapping(value = "/redNotification/getInvRedNoTerminal",
        produces = { "application/json" },
        method = RequestMethod.POST)
    MakeOutBeforeConfirmedResponse getInvRedNoTerminal(@ApiParam(value = "request", required = true) @RequestBody MsGetInvRedNoTerminalRequest id);


    @ApiOperation(value = "获取业务单下红字信息", notes = "", response = MsGetInvoiceRedNoByBillResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetInvoiceRedNoByBillResponse.class) })
    @RequestMapping(value = "/redNotification/getInvoiceRedNoByBill",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetInvoiceRedNoByBillResponse getInvoiceRedNoByBill(@ApiParam(value = "request", required = true) @RequestBody MsGetInvoiceRedNoByBillRequest id);


    @ApiOperation(value = "获取红字信息各状态数量", notes = "", response = MsGetRedNoAmountResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetRedNoAmountResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoAmount",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRedNoAmountResponse getRedNoAmount(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoListByInvoiceRequest id);


    @ApiOperation(value = "获取红字信息详情", notes = "", response = MsGetRedNoDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetRedNoDetailResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoDetail",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRedNoDetailResponse getRedNoDetail(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoDetailRequest id);


    @ApiOperation(value = "获取业务单列表", notes = "", response = MsGetRedNoListByByBillResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetRedNoListByByBillResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoListByByBill",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRedNoListByByBillResponse getRedNoListByByBill(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoListByByBillRequest id);


    @ApiOperation(value = "获取发票列表", notes = "", response = MsGetRedNoListByInvoiceResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetRedNoListByInvoiceResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoListByInvoice",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRedNoListByInvoiceResponse getRedNoListByInvoice(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoListByInvoiceRequest id);


    @ApiOperation(value = "获取上传结果", notes = "", response = MsGetRedNoUploadResultResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetRedNoUploadResultResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoUploadResult",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRedNoUploadResultResponse getRedNoUploadResult(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoUploadResultRequest id);


    @ApiOperation(value = "申请业务单所有红字信息", notes = "", response = MsSubmitBillRedNoAllResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsSubmitBillRedNoAllResponse.class) })
    @RequestMapping(value = "/redNotification/submitBillRedNoAll",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsSubmitBillRedNoAllResponse submitBillRedNoAll(@ApiParam(value = "request", required = true) @RequestBody MsSubmitBillRedNoAllRequest id);


    @ApiOperation(value = "批量提交红字信息详情", notes = "", response = MsSubmitRedNoAllResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsSubmitRedNoAllResponse.class) })
    @RequestMapping(value = "/redNotification/submitRedNoAll",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsSubmitRedNoAllResponse submitRedNoAll(@ApiParam(value = "request", required = true) @RequestBody MsSubmitRedNoAllRequest id);

    @ApiOperation(value = "获取申请结果", notes = "", response = MsGetApplyResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGetApplyResultResponse.class) })
    @RequestMapping(value = "/redNotification/getApplyResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetApplyResultResponse getApplyResult(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetApplyResultRequest id);

    @ApiOperation(value = "生成红字信息表pdf（根据发票）", notes = "", response = MsGenerateRedNoPdfByInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGenerateRedNoPdfByInvoiceResponse.class) })
    @RequestMapping(value = "/redNotification/generateRedNoPdfByInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGenerateRedNoPdfByInvoiceResponse generateRedNoPdfByInvoice(@ApiParam(value = "request", required = true) @RequestBody MsGenerateRedNoPdfByInvoiceRequest request);


    @ApiOperation(value = "生成红字信息表pdf（根据业务单）", notes = "", response = MsGenerateRedNoPdfByBillResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = MsGenerateRedNoPdfByBillResponse.class) })
    @RequestMapping(value = "/redNotification/generateRedNoPdfByBill",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGenerateRedNoPdfByBillResponse generateRedNoPdfByBill(@ApiParam(value = "request", required = true) @RequestBody MsGenerateRedNoPdfByBillRequest request);
}
