package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * ConfirmedPreInvoice
 */

@JsonInclude(NON_NULL)
public class ConfirmedPreInvoice {
  @JsonProperty("batchNo")
  private Long batchNo = null;

  @JsonProperty("preInvoiceIds")
  private List<Long> preInvoiceIds = new ArrayList<Long>();

  @JsonIgnore
  public ConfirmedPreInvoice batchNo(Long batchNo) {
    this.batchNo = batchNo;
    return this;
  }

   /**
   * 批次流水号
   * @return batchNo
  **/
  @ApiModelProperty(value = "批次流水号")
  public Long getBatchNo() {
    return batchNo;
  }

  public void setBatchNo(Long batchNo) {
    this.batchNo = batchNo;
  }

  @JsonIgnore
  public ConfirmedPreInvoice preInvoiceIds(List<Long> preInvoiceIds) {
    this.preInvoiceIds = preInvoiceIds;
    return this;
  }

  public ConfirmedPreInvoice addPreInvoiceIdsItem(Long preInvoiceIdsItem) {
    this.preInvoiceIds.add(preInvoiceIdsItem);
    return this;
  }

   /**
   * 预制发票id集合
   * @return preInvoiceIds
  **/
  @ApiModelProperty(value = "预制发票id集合")
  public List<Long> getPreInvoiceIds() {
    return preInvoiceIds;
  }

  public void setPreInvoiceIds(List<Long> preInvoiceIds) {
    this.preInvoiceIds = preInvoiceIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConfirmedPreInvoice confirmedPreInvoice = (ConfirmedPreInvoice) o;
    return Objects.equals(this.batchNo, confirmedPreInvoice.batchNo) &&
        Objects.equals(this.preInvoiceIds, confirmedPreInvoice.preInvoiceIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchNo, preInvoiceIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConfirmedPreInvoice {\n");

    sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
    sb.append("    preInvoiceIds: ").append(toIndentedString(preInvoiceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
