package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * ExportInvoicePDFRequest
 */

@JsonInclude(NON_NULL)
public class ExportInvoicePDFRequest {
    @JsonProperty("conditions")
    private Conditions conditions = null;

  @JsonProperty("isAllSelected")
  private Boolean isAllSelected = null;

  @JsonProperty("includes")
  private List<Long> includes = new ArrayList<Long>();

  @JsonProperty("excludes")
  private List<Long> excludes = new ArrayList<Long>();

  @JsonProperty("exportModel")
  private Integer exportModel = null;

  @JsonProperty("mergeType")
  @ApiModelProperty(value = "合并类型0-不合并导出 1-全部合并导出 2-按销方合并导出 3-按购方合并导出")
  private Integer mergeType = 0;

  @JsonIgnore
  public ExportInvoicePDFRequest coditions(Conditions coditions) {
      this.conditions = coditions;
    return this;
  }

   /**
    * Get conditions
    * @return conditions
  **/
  @ApiModelProperty(value = "")
  public Conditions getConditions() {
      return conditions;
  }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
  }

  @JsonIgnore
  public ExportInvoicePDFRequest isAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
    return this;
  }

   /**
   * 是否全选：true-全选 false-非全选
   * @return isAllSelected
  **/
  @ApiModelProperty(value = "是否全选：true-全选 false-非全选")
  public Boolean getIsAllSelected() {
    return isAllSelected;
  }

  public void setIsAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
  }

  @JsonIgnore
  public ExportInvoicePDFRequest includes(List<Long> includes) {
    this.includes = includes;
    return this;
  }

  public ExportInvoicePDFRequest addIncludesItem(Long includesItem) {
    this.includes.add(includesItem);
    return this;
  }

   /**
   * 包含项-发票序列号主键列表
   * @return includes
  **/
  @ApiModelProperty(value = "包含项-发票序列号主键列表")
  public List<Long> getIncludes() {
    return includes;
  }

  public void setIncludes(List<Long> includes) {
    this.includes = includes;
  }

  @JsonIgnore
  public ExportInvoicePDFRequest excludes(List<Long> excludes) {
    this.excludes = excludes;
    return this;
  }

  public ExportInvoicePDFRequest addExcludesItem(Long excludesItem) {
    this.excludes.add(excludesItem);
    return this;
  }

   /**
   * 排除项-发票序列号主键列表
   * @return excludes
  **/
  @ApiModelProperty(value = "排除项-发票序列号主键列表")
  public List<Long> getExcludes() {
    return excludes;
  }

  public void setExcludes(List<Long> excludes) {
    this.excludes = excludes;
  }

  @JsonIgnore
  public ExportInvoicePDFRequest exportModel(Integer exportModel) {
    this.exportModel = exportModel;
    return this;
  }

  /**
   * 导出类型：1-发票PDF 2-仅销货清单
   * @return exportModel
  **/
  @ApiModelProperty(value = "导出类型：1-发票PDF 2-仅销货清单")
  public Integer getExportModel() {
    return exportModel;
  }

  public void setExportModel(Integer exportModel) {
    this.exportModel = exportModel;
  }


  public Integer getMergeType() {
    return mergeType;
  }

  public void setMergeType(Integer mergeType) {
    this.mergeType = mergeType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExportInvoicePDFRequest exportInvoicePDFRequest = (ExportInvoicePDFRequest) o;
      return Objects.equals(this.conditions, exportInvoicePDFRequest.conditions) &&
        Objects.equals(this.isAllSelected, exportInvoicePDFRequest.isAllSelected) &&
        Objects.equals(this.includes, exportInvoicePDFRequest.includes) &&
        Objects.equals(this.excludes, exportInvoicePDFRequest.excludes) &&
        Objects.equals(this.exportModel, exportInvoicePDFRequest.exportModel);
  }

  @Override
  public int hashCode() {
      return Objects.hash(conditions, isAllSelected, includes, excludes, exportModel);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExportInvoicePDFRequest {\n");

      sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    isAllSelected: ").append(toIndentedString(isAllSelected)).append("\n");
    sb.append("    includes: ").append(toIndentedString(includes)).append("\n");
    sb.append("    excludes: ").append(toIndentedString(excludes)).append("\n");
    sb.append("    exportModel: ").append(toIndentedString(exportModel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
