package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Map;

@ApiModel
public class MakeOutInvoiceResult {

    @ApiModelProperty(value = "含税总金额")
    private String totalTaxAmount;

    @ApiModelProperty(value = "不含税总金额")
    private String totalWithoutAmount;

    @ApiModelProperty(value = "总数")
    private Long total;

    @ApiModelProperty("全部全选条件")
    private Map<String, Object> condition;

    @ApiModelProperty("已开发票信息")
    private List<QuerySellerInvoice> invoices;

    public String getTotalTaxAmount() {
        return totalTaxAmount;
    }

    public void setTotalTaxAmount(String totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }

    public String getTotalWithoutAmount() {
        return totalWithoutAmount;
    }

    public void setTotalWithoutAmount(String totalWithoutAmount) {
        this.totalWithoutAmount = totalWithoutAmount;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public List<QuerySellerInvoice> getInvoices() {
        return invoices;
    }

    public void setInvoices(List<QuerySellerInvoice> invoices) {
        this.invoices = invoices;
    }

    public Map<String, Object> getCondition() {
        return condition;
    }

    public void setCondition(Map<String, Object> condition) {
        this.condition = condition;
    }

    @Override
    public String toString() {
        return "MakeOutInvoiceResult{" +
                "totalTaxAmount='" + totalTaxAmount + '\'' +
                ", totalWithoutAmount='" + totalWithoutAmount + '\'' +
                ", total=" + total +
                ", condition=" + condition +
                ", invoices=" + invoices +
                '}';
    }
}
