package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票开票信息
 */
@ApiModel(description = "预制发票开票信息")

@JsonInclude(NON_NULL)
public class MakeOutPreInvoiceInfo {
    @JsonProperty("deviceId")
    @NotNull
    private Long deviceId;

    @ApiModelProperty(value = "设备唯一码 单盘必填")
    private String deviceUn;

    @JsonProperty("terminalId")
    @NotNull
    private Long terminalId;

    @ApiModelProperty(value = "终端唯一码")
    private String terminalUn;

    @ApiModelProperty(value = "开票模式, 1=单盘，2=服务器")
    @NotNull
    private String terminalType;

    @JsonProperty("preInvoiceIds")
    @NotEmpty
    private List<Long> preInvoiceIds;

    @JsonProperty("tenantNo")
    private String tenantNo = null;

    @JsonProperty("companyId")
    private String companyId = null;

    @ApiModelProperty("最新公司名称")
    private String newCompanyName;

    @JsonProperty("nextInvoiceNo")
    private String nextInvoiceNo = null;

    @JsonProperty("nextInvoiceCode")
    private String nextInvoiceCode = null;

    @ApiModelProperty(value = "开票人")
    private String backupDrawer;

    @JsonProperty("terminalCode")
    @ApiModelProperty(value = "终端编码")
    private String terminalCode;


    @JsonProperty("sort")
    @ApiModelProperty(value = "排序字段")
    private Sort sort;

    @JsonIgnore
    public MakeOutPreInvoiceInfo deviceId(Long deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    /**
     * 开票设备ID
     *
     * @return deviceId
     **/
    @ApiModelProperty(value = "开票设备ID")
    public Long getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    @JsonIgnore
    public MakeOutPreInvoiceInfo terminalId(Long terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    /**
     * 开票终端ID
     *
     * @return terminalId
     **/
    @ApiModelProperty(value = "开票终端ID")
    public Long getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(Long terminalId) {
        this.terminalId = terminalId;
    }

    @JsonIgnore
    public MakeOutPreInvoiceInfo tenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
        return this;
    }

    /**
     * 集团代码
     *
     * @return tenantNo
     **/
    @ApiModelProperty(value = "集团代码")
    public String getTenantNo() {
        return tenantNo;
    }

    public void setTenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
    }

    @JsonIgnore
    public MakeOutPreInvoiceInfo companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
     * 公司id
     *
     * @return companyId
     **/
    @ApiModelProperty(value = "公司id")
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }


    /**
     * 预制发票id集合
     *
     * @return preInvoiceIds
     **/
    @ApiModelProperty(value = "预制发票id集合")
    public List<Long> getPreInvoiceIds() {
        return preInvoiceIds;
    }

    public void setPreInvoiceIds(List<Long> preInvoiceIds) {
        this.preInvoiceIds = preInvoiceIds;
    }

    @JsonIgnore
    public MakeOutPreInvoiceInfo nextInvoiceNo(String nextInvoiceNo) {
        this.nextInvoiceNo = nextInvoiceNo;
        return this;
    }

    /**
     * 下一张发票号码
     *
     * @return nextInvoiceNo
     **/
    @ApiModelProperty(value = "下一张发票号码")
    public String getNextInvoiceNo() {
        return nextInvoiceNo;
    }

    public void setNextInvoiceNo(String nextInvoiceNo) {
        this.nextInvoiceNo = nextInvoiceNo;
    }

    @JsonIgnore
    public MakeOutPreInvoiceInfo nextInvoiceCode(String nextInvoiceCode) {
        this.nextInvoiceCode = nextInvoiceCode;
        return this;
    }

    public String getBackupDrawer() {
        return backupDrawer;
    }

    public void setBackupDrawer(String backupDrawer) {
        this.backupDrawer = backupDrawer;
    }

    /**
     * 下一张发票代码
     *
     * @return nextInvoiceCode
     **/
    @ApiModelProperty(value = "下一张发票代码")
    public String getNextInvoiceCode() {
        return nextInvoiceCode;
    }

    public void setNextInvoiceCode(String nextInvoiceCode) {
        this.nextInvoiceCode = nextInvoiceCode;
    }


    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    public String getNewCompanyName() {
        return newCompanyName;
    }

    public void setNewCompanyName(String newCompanyName) {
        this.newCompanyName = newCompanyName;
    }

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }

    public Sort getSort() {
        return sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    @Override
    public String toString() {
        return "MakeOutPreInvoiceInfo{" +
                "deviceId=" + deviceId +
                ", terminalId=" + terminalId +
                ", terminalType='" + terminalType + '\'' +
                ", preInvoiceIds=" + preInvoiceIds +
                ", tenantNo='" + tenantNo + '\'' +
                ", companyId='" + companyId + '\'' +
                ", newCompanyName='" + newCompanyName + '\'' +
                ", nextInvoiceNo='" + nextInvoiceNo + '\'' +
                ", nextInvoiceCode='" + nextInvoiceCode + '\'' +
                ", sort='" + sort + '\'' +
                '}';
    }
}
