package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDeleteRedNoAllRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("applyTaxNo")
  private String applyTaxNo = null;

  @JsonProperty("applyStatus")
  private Integer applyStatus = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("isAllSelected")
  private String isAllSelected = null;

  @JsonProperty("excludes")
  private List<Long> excludes = new ArrayList<Long>();

  @JsonProperty("includes")
  private List<Long> includes = new ArrayList<Long>();

  @JsonIgnore
  public MsDeleteRedNoAllRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AP：购方 AR-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1 销方 2购方
   * @return userRole
  **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest applyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
    return this;
  }

   /**
   * 申请状态:1 未申请 2.申请中 3.已申请 4.全部
   * @return applyingStatus
  **/
  @ApiModelProperty(value = "申请状态:1 未申请 2.申请中 3.已申请 4.全部")
  public Integer getApplyingStatus() {
    return applyingStatus;
  }

  public void setApplyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

   /**
   * 业务单号
   * @return billNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest applyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return applyTaxNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getApplyTaxNo() {
    return applyTaxNo;
  }

  public void setApplyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest applyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
    return this;
  }

   /**
   * 申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？
   * @return applyStatus
  **/
  @ApiModelProperty(value = "申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？")
  public Integer getApplyStatus() {
    return applyStatus;
  }

  public void setApplyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest isAllSelected(String isAllSelected) {
    this.isAllSelected = isAllSelected;
    return this;
  }

   /**
   * 是否全选
   * @return isAllSelected
  **/
  @ApiModelProperty(value = "是否全选")
  public String getIsAllSelected() {
    return isAllSelected;
  }

  public void setIsAllSelected(String isAllSelected) {
    this.isAllSelected = isAllSelected;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest excludes(List<Long> excludes) {
    this.excludes = excludes;
    return this;
  }

  public MsDeleteRedNoAllRequest addExcludesItem(Long excludesItem) {
    this.excludes.add(excludesItem);
    return this;
  }

   /**
   * 发票对象
   * @return excludes
  **/
  @ApiModelProperty(value = "发票对象")
  public List<Long> getExcludes() {
    return excludes;
  }

  public void setExcludes(List<Long> excludes) {
    this.excludes = excludes;
  }

  @JsonIgnore
  public MsDeleteRedNoAllRequest includes(List<Long> includes) {
    this.includes = includes;
    return this;
  }

  public MsDeleteRedNoAllRequest addIncludesItem(Long includesItem) {
    this.includes.add(includesItem);
    return this;
  }

   /**
   * 发票对象
   * @return includes
  **/
  @ApiModelProperty(value = "发票对象")
  public List<Long> getIncludes() {
    return includes;
  }

  public void setIncludes(List<Long> includes) {
    this.includes = includes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeleteRedNoAllRequest deleteRedNoAllRequest = (MsDeleteRedNoAllRequest) o;
    return Objects.equals(this.businessBillType, deleteRedNoAllRequest.businessBillType) &&
        Objects.equals(this.userRole, deleteRedNoAllRequest.userRole) &&
        Objects.equals(this.applyingStatus, deleteRedNoAllRequest.applyingStatus) &&
        Objects.equals(this.sellerTaxNo, deleteRedNoAllRequest.sellerTaxNo) &&
        Objects.equals(this.purchaserTaxNo, deleteRedNoAllRequest.purchaserTaxNo) &&
        Objects.equals(this.billNo, deleteRedNoAllRequest.billNo) &&
        Objects.equals(this.invoiceCode, deleteRedNoAllRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, deleteRedNoAllRequest.invoiceNo) &&
        Objects.equals(this.applyTaxNo, deleteRedNoAllRequest.applyTaxNo) &&
        Objects.equals(this.applyStatus, deleteRedNoAllRequest.applyStatus) &&
        Objects.equals(this.createTime, deleteRedNoAllRequest.createTime) &&
        Objects.equals(this.isAllSelected, deleteRedNoAllRequest.isAllSelected) &&
        Objects.equals(this.excludes, deleteRedNoAllRequest.excludes) &&
        Objects.equals(this.includes, deleteRedNoAllRequest.includes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, userRole, applyingStatus, sellerTaxNo, purchaserTaxNo, billNo, invoiceCode, invoiceNo, applyTaxNo, applyStatus, createTime, isAllSelected, excludes, includes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeleteRedNoAllRequest {\n");

    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    applyingStatus: ").append(toIndentedString(applyingStatus)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    billNo: ").append(toIndentedString(billNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    applyTaxNo: ").append(toIndentedString(applyTaxNo)).append("\n");
    sb.append("    applyStatus: ").append(toIndentedString(applyStatus)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    isAllSelected: ").append(toIndentedString(isAllSelected)).append("\n");
    sb.append("    excludes: ").append(toIndentedString(excludes)).append("\n");
    sb.append("    includes: ").append(toIndentedString(includes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
