package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoAmountRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonProperty("applyStatus")
  private Integer applyStatus = null;

  @JsonIgnore
  public MsGetRedNoAmountRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AP：购方 AR-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsGetRedNoAmountRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1 销方 2购方
   * @return userRole
  **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsGetRedNoAmountRequest applyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
    return this;
  }

   /**
   * 申请状态:1 未申请 2.申请中 3.已申请 4.全部
   * @return applyingStatus
  **/
  @ApiModelProperty(value = "申请状态:1 未申请 2.申请中 3.已申请 4.全部")
  public Integer getApplyingStatus() {
    return applyingStatus;
  }

  public void setApplyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
  }

  @JsonIgnore
  public MsGetRedNoAmountRequest applyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
    return this;
  }

   /**
   * 申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？
   * @return applyStatus
  **/
  @ApiModelProperty(value = "申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？")
  public Integer getApplyStatus() {
    return applyStatus;
  }

  public void setApplyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoAmountRequest getRedNoAmountRequest = (MsGetRedNoAmountRequest) o;
    return Objects.equals(this.businessBillType, getRedNoAmountRequest.businessBillType) &&
        Objects.equals(this.userRole, getRedNoAmountRequest.userRole) &&
        Objects.equals(this.applyingStatus, getRedNoAmountRequest.applyingStatus) &&
        Objects.equals(this.applyStatus, getRedNoAmountRequest.applyStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, userRole, applyingStatus, applyStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoAmountRequest {\n");

    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    applyingStatus: ").append(toIndentedString(applyingStatus)).append("\n");
    sb.append("    applyStatus: ").append(toIndentedString(applyStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
