package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoListByInvoiceRequest {

  @JsonProperty("id")
  private Long id;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("applyTaxNo")
  private String applyTaxNo = null;

  @JsonProperty("applyStatus")
  private String applyStatus = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("login")
  private Integer login;

  @JsonProperty("applyStartDate")
  private String applyStartDate;

  @JsonProperty("applyendDate")
  private String applyendDate;

  @JsonProperty("requestBillNo")
  private String requestBillNo = null;

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

  /**
   * AP：购方 AR-销方
   * @return businessBillType
   **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

  /**
   * 1 销方 2购方
   * @return userRole
   **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest applyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
    return this;
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  /**
   * 申请状态:1 未申请 2.申请中 3.已申请 4.全部
   * @return applyingStatus
   **/
  @ApiModelProperty(value = "申请状态:1 未申请 2.申请中 3.已申请 4.全部")
  public Integer getApplyingStatus() {
    return applyingStatus;
  }

  public void setApplyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

  /**
   * 销方税号
   * @return sellerTaxNo
   **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

  /**
   * 购方税号
   * @return purchaserTaxNo
   **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

  /**
   * 业务单号
   * @return billNo
   **/
  @ApiModelProperty(value = "业务单号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

  /**
   * 发票代码
   * @return invoiceCode
   **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

  /**
   * 发票号码
   * @return invoiceNo
   **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest applyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
    return this;
  }

  /**
   * 红字信息表编号
   * @return applyTaxNo
   **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getApplyTaxNo() {
    return applyTaxNo;
  }

  public void setApplyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest applyStatus(String applyStatus) {
    this.applyStatus = applyStatus;
    return this;
  }

  /**
   * 申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？
   * @return applyStatus
   **/
  @ApiModelProperty(value = "申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？")
  public String getApplyStatus() {
    return applyStatus;
  }

  public void setApplyStatus(String applyStatus) {
    this.applyStatus = applyStatus;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * 创建时间
   * @return createTime
   **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

  /**
   * return pageno
   * @return pageNo
   **/
  @ApiModelProperty(value = "return pageno")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsGetRedNoListByInvoiceRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * return pagesize
   * @return pageSize
   **/
  @ApiModelProperty(value = "return pagesize")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  public Integer getLogin() {
    return login;
  }

  public void setLogin(Integer login) {
    this.login = login;
  }

  public String getApplyStartDate() {
    return applyStartDate;
  }

  public void setApplyStartDate(String applyStartDate) {
    this.applyStartDate = applyStartDate;
  }

  public String getApplyendDate() {
    return applyendDate;
  }

  public void setApplyendDate(String applyendDate) {
    this.applyendDate = applyendDate;
  }

  public String getRequestBillNo() {
    return requestBillNo;
  }

  public void setRequestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
  }
  
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoListByInvoiceRequest getRedNoListByInvoiceRequest = (MsGetRedNoListByInvoiceRequest) o;
    return Objects.equals(this.businessBillType, getRedNoListByInvoiceRequest.businessBillType) &&
            Objects.equals(this.userRole, getRedNoListByInvoiceRequest.userRole) &&
            Objects.equals(this.applyingStatus, getRedNoListByInvoiceRequest.applyingStatus) &&
            Objects.equals(this.sellerTaxNo, getRedNoListByInvoiceRequest.sellerTaxNo) &&
            Objects.equals(this.purchaserTaxNo, getRedNoListByInvoiceRequest.purchaserTaxNo) &&
            Objects.equals(this.billNo, getRedNoListByInvoiceRequest.billNo) &&
            Objects.equals(this.invoiceCode, getRedNoListByInvoiceRequest.invoiceCode) &&
            Objects.equals(this.invoiceNo, getRedNoListByInvoiceRequest.invoiceNo) &&
            Objects.equals(this.applyTaxNo, getRedNoListByInvoiceRequest.applyTaxNo) &&
            Objects.equals(this.applyStatus, getRedNoListByInvoiceRequest.applyStatus) &&
            Objects.equals(this.createTime, getRedNoListByInvoiceRequest.createTime) &&
            Objects.equals(this.pageNo, getRedNoListByInvoiceRequest.pageNo) &&
            Objects.equals(this.pageSize, getRedNoListByInvoiceRequest.pageSize)&&
            Objects.equals(this.requestBillNo, getRedNoListByInvoiceRequest.requestBillNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, userRole, applyingStatus, sellerTaxNo, purchaserTaxNo, billNo, invoiceCode, invoiceNo, applyTaxNo, applyStatus, createTime, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoListByInvoiceRequest {\n");

    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    applyingStatus: ").append(toIndentedString(applyingStatus)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    billNo: ").append(toIndentedString(billNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    applyTaxNo: ").append(toIndentedString(applyTaxNo)).append("\n");
    sb.append("    applyStatus: ").append(toIndentedString(applyStatus)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    requestBillNo: ").append(toIndentedString(requestBillNo)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
