package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 响应对象
 */
@ApiModel(description = "响应对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSubmitBillRedNoAllResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private String result = null;

  @JsonIgnore
  public MsSubmitBillRedNoAllResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsSubmitBillRedNoAllResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsSubmitBillRedNoAllResponse result(String result) {
    this.result = result;
    return this;
  }

   /**
   * 结果
   * @return result
  **/
  @ApiModelProperty(value = "结果")
  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSubmitBillRedNoAllResponse submitBillRedNoAllResponse = (MsSubmitBillRedNoAllResponse) o;
    return Objects.equals(this.code, submitBillRedNoAllResponse.code) &&
        Objects.equals(this.message, submitBillRedNoAllResponse.message) &&
        Objects.equals(this.result, submitBillRedNoAllResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSubmitBillRedNoAllResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
