package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 作废发票轮询结果对象
 */
@ApiModel(description = "作废发票轮询结果对象")

@JsonInclude(NON_NULL)
public class PollingAbandonInvoiceResult extends PollingModel {

    @ApiModelProperty(value = "作废发票失败总数")
    private int failedCount = 0;
    @ApiModelProperty(value = "作废发票成功总数")
    private int successCount = 0;


    public int getFailedCount() {
        return failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public int getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    @Override
    public String toString() {
        return "PollingAbandonInvoiceResult{" +
                "failedCount=" + failedCount + "successCount" + successCount +
                "} " + super.toString();
    }
}
