package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * PrintSellerInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class PrintSellerInvoiceRequest {
  @ApiModelProperty(value = "可打印发票id列表")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("printInvoiceTerminalId")
  private Long printInvoiceTerminalId = null;

  @JsonProperty("printSellListTerminalId")
  private Long printSellListTerminalId = null;

  @JsonProperty("deviceIdForList")
  private Long deviceIdForList = null;

  @JsonProperty("deviceIdForInv")
  private Long deviceIdForInv = null;

  @JsonProperty("deviceUn")
  private String deviceUn;

  @JsonProperty("terminalUn")
  private String terminalUn;

  @JsonProperty("printContent")
  private String printContent = null;

  @JsonProperty("supportServiceForInv")
  private List<String> supportServiceForInv = Lists.newArrayList();

  @JsonProperty("supportServiceForList")
  private List<String> supportServiceForList = Lists.newArrayList();

  @JsonProperty("terminalTypeForInv")
  private Integer terminalTypeForInv = null;

  @JsonProperty("terminalTypeForList")
  private Integer terminalTypeForList = null;


  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  /**
   * 可打印发票id列表
   * @return invoiceIds
   **/
  @ApiModelProperty(value = "可打印发票id列表")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }


  @JsonIgnore
  public PrintSellerInvoiceRequest deviceIdForList(Long deviceIdForList) {
    this.deviceIdForList = deviceIdForList;
    return this;
  }

   /**
   * 打印销货清单设备id
   * @return deviceIdForList
  **/
  @ApiModelProperty(value = "打印销货清单设备id")
  public Long getDeviceIdForList() {
    return deviceIdForList;
  }

  public void setDeviceIdForList(Long deviceIdForList) {
    this.deviceIdForList = deviceIdForList;
  }

  @JsonIgnore
  public PrintSellerInvoiceRequest deviceIdForInv(Long deviceIdForInv) {
    this.deviceIdForInv = deviceIdForInv;
    return this;
  }

  /**
   * 打印发票设备id
   * @return deviceIdForInv
   **/
  @ApiModelProperty(value = "打印发票设备id")
  public Long getDeviceIdForInv() {
    return deviceIdForInv;
  }

  public void setDeviceIdForInv(Long deviceIdForInv) {
    this.deviceIdForInv = deviceIdForInv;
  }

  @JsonIgnore
  public PrintSellerInvoiceRequest printInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
    return this;
  }

  /**
   * 打印发票终端id
   * @return printInvoiceTerminalId
   **/
  @ApiModelProperty(value = "打印发票终端id")
  public Long getPrintInvoiceTerminalId() {
    return printInvoiceTerminalId;
  }

  public void setPrintInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
  }

  @JsonIgnore
  public PrintSellerInvoiceRequest printSellListTerminalId(Long printSellListTerminalId) {
    this.printSellListTerminalId = printSellListTerminalId;
    return this;
  }
  @ApiModelProperty(value = "打印发票服务类型")
  public List<String> getSupportServiceForInv() {
    return supportServiceForInv;
  }

  public void setSupportServiceForInv(List<String> supportServiceForInv) {
    this.supportServiceForInv = supportServiceForInv;
  }
  @ApiModelProperty(value = "打印销货清单服务类型")
  public List<String> getSupportServiceForList() {
    return supportServiceForList;
  }

  public void setSupportServiceForList(List<String> supportServiceForList) {
    this.supportServiceForList = supportServiceForList;
  }
  @ApiModelProperty(value = "打印发票终端类型")
  public Integer getTerminalTypeForInv() {
    return terminalTypeForInv;
  }

  public void setTerminalTypeForInv(Integer terminalTypeForInv) {
    this.terminalTypeForInv = terminalTypeForInv;
  }
  @ApiModelProperty(value = "打印销货清单终端类型")
  public Integer getTerminalTypeForList() {
    return terminalTypeForList;
  }

  public void setTerminalTypeForList(Integer terminalTypeForList) {
    this.terminalTypeForList = terminalTypeForList;
  }

  /**
   * 打印销货清单终端id
   * @return printSellListTerminalId
   **/
  @ApiModelProperty(value = "打印销货清单终端id")
  public Long getPrintSellListTerminalId() {
    return printSellListTerminalId;
  }

  public void setPrintSellListTerminalId(Long printSellListTerminalId) {
    this.printSellListTerminalId = printSellListTerminalId;
  }

  @JsonIgnore
  public PrintSellerInvoiceRequest printContent(String printContent) {
    this.printContent = printContent;
    return this;
  }

   /**
   * 打印内容 0-发票带销货清单 1-发票（不含销货清单） 2-销货清单
   * @return printContent
  **/
  @ApiModelProperty(value = "打印内容 0-发票带销货清单 1-发票（不含销货清单） 2-销货清单")
  public String getPrintContent() {
    return printContent;
  }

  public void setPrintContent(String printContent) {
    this.printContent = printContent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrintSellerInvoiceRequest printSellerInvoiceRequest = (PrintSellerInvoiceRequest) o;
    return Objects.equals(this.invoiceIds, printSellerInvoiceRequest.invoiceIds) &&
        //Objects.equals(this.deviceId, printSellerInvoiceRequest.deviceId) &&
        Objects.equals(this.printInvoiceTerminalId, printSellerInvoiceRequest.printInvoiceTerminalId) &&
        Objects.equals(this.printSellListTerminalId, printSellerInvoiceRequest.printSellListTerminalId) &&
        Objects.equals(this.printContent, printSellerInvoiceRequest.printContent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, deviceIdForInv, deviceIdForList, printInvoiceTerminalId, printSellListTerminalId, printContent);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrintSellerInvoiceRequest {\n");

    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    deviceIdForInv: ").append(toIndentedString(deviceIdForInv)).append("\n");
    sb.append("    deviceIdForList: ").append(toIndentedString(deviceIdForList)).append("\n");
    sb.append("    printInvoiceTerminalId: ").append(toIndentedString(printInvoiceTerminalId)).append("\n");
    sb.append("    printSellListTerminalId: ").append(toIndentedString(printSellListTerminalId)).append("\n");
    sb.append("    printContent: ").append(toIndentedString(printContent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
