package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * ShowInvoiceHistoryRequest
 */

@JsonInclude(NON_NULL)
public class ShowInvoiceHistoryRequest {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonIgnore
  public ShowInvoiceHistoryRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票序列号主键
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票序列号主键")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShowInvoiceHistoryRequest showInvoiceHistoryRequest = (ShowInvoiceHistoryRequest) o;
    return Objects.equals(this.invoiceId, showInvoiceHistoryRequest.invoiceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShowInvoiceHistoryRequest {\n");

    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
