package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ApiModel
public class SplitRule {

    @ApiModelProperty("规则ID")
    private Long ruleId;

    @ApiModelProperty("拆票限额")
    private BigDecimal invoiceLimit;

    @ApiModelProperty("可拆票字段")
    private List<String> splitFiledList  = new ArrayList<>();

    @ApiModelProperty("设备类型")
    private String taxDeviceType;

    @ApiModelProperty("明细顺序")
    private String itemSort;

    @ApiModelProperty("销货清单最大行数")
    private Integer salesListMaxRow;

    @ApiModelProperty("单价数量选项")
    private String unitPriceAmountOps;

    @ApiModelProperty("金额拆分规则")
    private String amountSplitRule;

    @ApiModelProperty("是否支持整形")
    private boolean integerOps = Boolean.FALSE;

    @ApiModelProperty("发票票面明细最大数")
    private Integer invoiceItemMaxRow;

    @ApiModelProperty("发票备注字段列表")
    private List<String> invoiceRemarkFiledList  = new ArrayList<>();

    @ApiModelProperty("折扣模式")
    private String discountMode;

    @ApiModelProperty("销货清单选项")
    private String saleListOption;

    @ApiModelProperty("发票规格")
    private String invoiceSpec;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("固定备注内容")
    private String fixedRemarkText;

    @ApiModelProperty("发票备注字段元数据")
    private List<RemarkFieldMetadata> remarkFiledMetadataBeanList;

    @ApiModelProperty("发票备注字段元数据")
    private List<RemarkFieldMetadata> remarkFiledMetadataList;

    @ApiModelProperty("商品名称拼接字段列表")
    private List<RemarkFieldMetadata> cargoNameFiledMetadatas;
    @ApiModelProperty("自定义商品品名长度, 默认100")
    private Integer cargoNameLength = 200;
    @ApiModelProperty("规格型号称拼接字段列表")
    private List<RemarkFieldMetadata> itemSpecFiledMetadatas;
    @ApiModelProperty("自定义规格型号名称长度, 默认40")
    private Integer itemSpecNameLength = 100;

    @ApiModelProperty("价格方式, 0=不含税，1=含税")
    private PriceMethod priceMethod;

    @ApiModelProperty("补充备注")
    private String extRemark;



    public BigDecimal getInvoiceLimit() {
        return invoiceLimit;
    }

    public void setInvoiceLimit(BigDecimal invoiceLimit) {
        this.invoiceLimit = invoiceLimit;
    }

    public List<String> getSplitFiledList() {
        return splitFiledList;
    }

    public void setSplitFiledList(List<String> splitFiledList) {
        this.splitFiledList = splitFiledList;
    }

    public String getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public String getItemSort() {
        return itemSort;
    }

    public void setItemSort(String itemSort) {
        this.itemSort = itemSort;
    }

    public Integer getSalesListMaxRow() {
        return salesListMaxRow;
    }

    public void setSalesListMaxRow(Integer salesListMaxRow) {
        this.salesListMaxRow = salesListMaxRow;
    }

    public String getUnitPriceAmountOps() {
        return unitPriceAmountOps;
    }

    public void setUnitPriceAmountOps(String unitPriceAmountOps) {
        this.unitPriceAmountOps = unitPriceAmountOps;
    }

    public String getAmountSplitRule() {
        return amountSplitRule;
    }

    public void setAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
    }

    public boolean isIntegerOps() {
        return integerOps;
    }

    public void setIntegerOps(boolean integerOps) {
        this.integerOps = integerOps;
    }

    public Integer getInvoiceItemMaxRow() {
        return invoiceItemMaxRow;
    }

    public void setInvoiceItemMaxRow(Integer invoiceItemMaxRow) {
        this.invoiceItemMaxRow = invoiceItemMaxRow;
    }

    public List<String> getInvoiceRemarkFiledList() {
        return invoiceRemarkFiledList;
    }

    public void setInvoiceRemarkFiledList(List<String> invoiceRemarkFiledList) {
        this.invoiceRemarkFiledList = invoiceRemarkFiledList;
    }

    public String getDiscountMode() {
        return discountMode;
    }

    public void setDiscountMode(String discountMode) {
        this.discountMode = discountMode;
    }

    public String getSaleListOption() {
        return saleListOption;
    }

    public void setSaleListOption(String saleListOption) {
        this.saleListOption = saleListOption;
    }

    public String getInvoiceSpec() {
        return invoiceSpec;
    }

    public void setInvoiceSpec(String invoiceSpec) {
        this.invoiceSpec = invoiceSpec;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }



    public String getFixedRemarkText() {
        return fixedRemarkText;
    }

    public void setFixedRemarkText(String fixedRemarkText) {
        this.fixedRemarkText = fixedRemarkText;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public List<RemarkFieldMetadata> getRemarkFiledMetadataBeanList() {
        return remarkFiledMetadataBeanList;
    }

    public void setRemarkFiledMetadataBeanList(List<RemarkFieldMetadata> remarkFiledMetadataBeanList) {
        this.remarkFiledMetadataBeanList = remarkFiledMetadataBeanList;
    }

    public PriceMethod getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(PriceMethod priceMethod) {
        this.priceMethod = priceMethod;
    }

    public String getExtRemark() {
        return extRemark;
    }

    public void setExtRemark(String extRemark) {
        this.extRemark = extRemark;
    }

    public List<RemarkFieldMetadata> getRemarkFiledMetadataList() {
        return remarkFiledMetadataList;
    }

    public void setRemarkFiledMetadataList(List<RemarkFieldMetadata> remarkFiledMetadataList) {
        this.remarkFiledMetadataList = remarkFiledMetadataList;
    }

    public List<RemarkFieldMetadata> getCargoNameFiledMetadatas() {
        return cargoNameFiledMetadatas;
    }

    public void setCargoNameFiledMetadatas(List<RemarkFieldMetadata> cargoNameFiledMetadatas) {
        this.cargoNameFiledMetadatas = cargoNameFiledMetadatas;
    }

    public Integer getCargoNameLength() {
        return cargoNameLength;
    }

    public void setCargoNameLength(Integer cargoNameLength) {
        this.cargoNameLength = cargoNameLength;
    }

    public List<RemarkFieldMetadata> getItemSpecFiledMetadatas() {
        return itemSpecFiledMetadatas;
    }

    public void setItemSpecFiledMetadatas(List<RemarkFieldMetadata> itemSpecFiledMetadatas) {
        this.itemSpecFiledMetadatas = itemSpecFiledMetadatas;
    }

    public Integer getItemSpecNameLength() {
        return itemSpecNameLength;
    }

    public void setItemSpecNameLength(Integer itemSpecNameLength) {
        this.itemSpecNameLength = itemSpecNameLength;
    }

    @Override
    public String toString() {
        return "SplitRule{" +
                "invoiceLimit=" + invoiceLimit +
                ", splitFiledList=" + splitFiledList +
                ", taxDeviceType='" + taxDeviceType + '\'' +
                ", itemSort='" + itemSort + '\'' +
                ", salesListMaxRow=" + salesListMaxRow +
                ", unitPriceAmountOps='" + unitPriceAmountOps + '\'' +
                ", amountSplitRule='" + amountSplitRule + '\'' +
                ", integerOps=" + integerOps +
                ", invoiceItemMaxRow=" + invoiceItemMaxRow +
                ", invoiceRemarkFiledList=" + invoiceRemarkFiledList +
                ", discountMode='" + discountMode + '\'' +
                ", saleListOption='" + saleListOption + '\'' +
                ", invoiceSpec='" + invoiceSpec + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", remarkFiledMetadataList=" + remarkFiledMetadataBeanList +
                '}';
    }
}
