package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(
        description = "发票金额信息"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AutoPdfInvoiceAmountInfo {
    @JsonProperty("amountWithTax")
    private String amountWithTax;
    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax;
    @JsonProperty("taxAmount")
    private String taxAmount;

    public AutoPdfInvoiceAmountInfo(String amountWithTax, String amountWithoutTax, String taxAmount) {
        this.amountWithTax = amountWithTax;
        this.amountWithoutTax = amountWithoutTax;
        this.taxAmount = taxAmount;
    }

    @ApiModelProperty("含税金额")
    public String getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(String amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @ApiModelProperty("不含税金额")
    public String getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @ApiModelProperty("税额")
    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    @Override
    public String toString() {
        return "AutoPdfInvoiceAmountInfo{" +
                "amountWithTax='" + amountWithTax + '\'' +
                ", amountWithoutTax='" + amountWithoutTax + '\'' +
                ", taxAmount='" + taxAmount + '\'' +
                '}';
    }
}
