package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

public class AutoPdfTaxInfo {

    @JsonProperty("preferentialTax")
    private String preferentialTax = null;
    @JsonProperty("taxPolicy")
    private String taxPolicy = null;
    @JsonProperty("taxRate")
    private String taxRate = null;
    @JsonProperty("zeroTax")
    private String zeroTax = null;

    public AutoPdfTaxInfo(String preferentialTax, String taxPolicy, String taxRate, String zeroTax) {
        this.preferentialTax = preferentialTax;
        this.taxPolicy = taxPolicy;
        this.taxRate = taxRate;
        this.zeroTax = zeroTax;
    }

    @JsonIgnore
    public AutoPdfTaxInfo preferentialTax(String preferentialTax) {
        this.preferentialTax = preferentialTax;
        return this;
    }

    @ApiModelProperty("是否享受税收优惠政策")
    public String getPreferentialTax() {
        return this.preferentialTax;
    }

    public void setPreferentialTax(String preferentialTax) {
        this.preferentialTax = preferentialTax;
    }

    @JsonIgnore
    public AutoPdfTaxInfo taxPolicy(String taxPolicy) {
        this.taxPolicy = taxPolicy;
        return this;
    }

    @ApiModelProperty("享受税收优惠政策内容。0税率时： 根据 zeroTax 的情况，分别填： 免税 / 不征税 / 普通0税率")
    public String getTaxPolicy() {
        return this.taxPolicy;
    }

    public void setTaxPolicy(String taxPolicy) {
        this.taxPolicy = taxPolicy;
    }

    @JsonIgnore
    public AutoPdfTaxInfo taxRate(String taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty("税率(例如，16%传0.16)")
    public String getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    @JsonIgnore
    public AutoPdfTaxInfo zeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    @ApiModelProperty("税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)")
    public String getZeroTax() {
        return this.zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoPdfTaxInfo that = (AutoPdfTaxInfo) o;
        return Objects.equals(preferentialTax, that.preferentialTax) &&
                Objects.equals(taxPolicy, that.taxPolicy) &&
                Objects.equals(taxRate, that.taxRate) &&
                Objects.equals(zeroTax, that.zeroTax);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preferentialTax, taxPolicy, taxRate, zeroTax);
    }

    @Override
    public String toString() {
        return "AutoPdfTaxInfo{" +
                "preferentialTax='" + preferentialTax + '\'' +
                ", taxPolicy='" + taxPolicy + '\'' +
                ", taxRate='" + taxRate + '\'' +
                ", zeroTax='" + zeroTax + '\'' +
                '}';
    }
}
