package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import java.util.Objects;
@ApiModel(
    description = "明细"
)
public class InvoiceDetailInfo {
    @JsonProperty("production")
    private ProductionInfo production = null;
    @JsonProperty("detailAmount")
    private InvoiceDetailAmountInfo detailAmount = null;
    @JsonProperty("tax")
    private TaxInfo tax = null;
    @JsonProperty("discountAmount")
    private DiscountAmountInfo discountAmount = null;

    public InvoiceDetailInfo(ProductionInfo production, InvoiceDetailAmountInfo detailAmount, TaxInfo tax, DiscountAmountInfo discountAmount) {
        this.production = production;
        this.detailAmount = detailAmount;
        this.tax = tax;
        this.discountAmount = discountAmount;
    }

    @JsonIgnore
    public InvoiceDetailInfo production(ProductionInfo production) {
        this.production = production;
        return this;
    }

    public InvoiceDetailInfo() {
    }

    @Valid
    @ApiModelProperty("发票明细商品或劳务信息")
    public ProductionInfo getProduction() {
        return this.production;
    }

    public void setProduction(ProductionInfo production) {
        this.production = production;
    }

    @JsonIgnore
    public InvoiceDetailInfo detailAmount(InvoiceDetailAmountInfo detailAmount) {
        this.detailAmount = detailAmount;
        return this;
    }

    @Valid
    @ApiModelProperty("发票明细金额信息")
    public InvoiceDetailAmountInfo getDetailAmount() {
        return this.detailAmount;
    }

    public void setDetailAmount(InvoiceDetailAmountInfo detailAmount) {
        this.detailAmount = detailAmount;
    }


    @JsonIgnore
    public InvoiceDetailInfo tax(TaxInfo tax) {
        this.tax = tax;
        return this;
    }

    @Valid
    @ApiModelProperty("税收信息")
    public TaxInfo getTax() {
        return this.tax;
    }

    public void setTax(TaxInfo tax) {
        this.tax = tax;
    }

    @JsonIgnore
    public InvoiceDetailInfo discountAmount(DiscountAmountInfo discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    @Valid
    @ApiModelProperty("折扣信息")
    public DiscountAmountInfo getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(DiscountAmountInfo discountAmount) {
        this.discountAmount = discountAmount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoiceDetailInfo that = (InvoiceDetailInfo) o;
        return Objects.equals(production, that.production) &&
                Objects.equals(detailAmount, that.detailAmount) &&
                Objects.equals(tax, that.tax) &&
                Objects.equals(discountAmount, that.discountAmount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(production, detailAmount, tax, discountAmount);
    }

    @Override
    public String toString() {
        return "InvoiceDetailInfo{" +
                "production=" + production +
                ", detailAmount=" + detailAmount +
                ", tax=" + tax +
                ", discountAmount=" + discountAmount +
                '}';
    }
    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
