package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

@ApiModel(
        description = "发票信息  当未收到底层结果时，接口返回发票列表为空。当部分收到底层结果时，仅返回有结果的发票。"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class InvoiceInfo {
    @JsonProperty("checkCode")
    private String checkCode = null;
    @JsonProperty("cipherText")
    private String cipherText = null;
    @JsonProperty("invoiceCode")
    private String invoiceCode = null;
    @JsonProperty("invoiceDate")
    private String invoiceDate = null;
    @JsonProperty("invoiceDateTime")
    private String invoiceDateTime = null;
    @JsonProperty("invalidDate")
    private String invalidDate = null;
    @JsonProperty("invoiceNo")
    private String invoiceNo = null;
    @JsonProperty("invoiceType")
    private String invoiceType = null;
    @JsonProperty("machineCode")
    private String machineCode = null;
    @JsonProperty("blockChain")
    private String blockChain = null;
    @JsonProperty("terminalUn")
    private String terminalUn = null;
    @JsonProperty("deviceUn")
    private String deviceUn = null;
    @JsonProperty("remark")
    private String remark = null;
    @JsonProperty("pid")
    private String pid = null;
    @JsonProperty("settlementNo")
    private String settlementNo = null;
    @JsonProperty("saleListItemName")
    private String saleListItemName = null;

    @JsonProperty("details")
    private List<InvoiceDetailInfo> details;
    @JsonProperty("invoiceAmount")
    private InvoiceAmountInfo invoiceAmount = null;
    @JsonProperty("operator")
    private OperatorInfo operator = null;
    @JsonProperty("purchaser")
    private PurchaserInfo purchaser = null;
    @JsonProperty("seller")
    private SellerInfo seller = null;
    @JsonProperty("control")
    private ControlInfo control = null;
    @JsonProperty("statusInfo")
    private StatusInfo statusInfo = null;
    @JsonProperty("redInfo")
    private RedInfo redInfo = null;
    @JsonProperty("vehicle")
    private VehicleInfo vehicle = null;

    public InvoiceInfo(String checkCode, String cipherText, String invoiceCode, String invoiceDate, String invoiceDateTime, String invalidDate, String invoiceNo, String invoiceType, String machineCode, String blockChain, String terminalUn, String deviceUn, String remark, String pid, String settlementNo, String saleListItemName, List<InvoiceDetailInfo> details, InvoiceAmountInfo invoiceAmount, OperatorInfo operator, PurchaserInfo purchaser, SellerInfo seller, ControlInfo control, StatusInfo statusInfo, RedInfo redInfo, VehicleInfo vehicle) {
        this.checkCode = checkCode;
        this.cipherText = cipherText;
        this.invoiceCode = invoiceCode;
        this.invoiceDate = invoiceDate;
        this.invoiceDateTime = invoiceDateTime;
        this.invalidDate = invalidDate;
        this.invoiceNo = invoiceNo;
        this.invoiceType = invoiceType;
        this.machineCode = machineCode;
        this.blockChain = blockChain;
        this.terminalUn = terminalUn;
        this.deviceUn = deviceUn;
        this.remark = remark;
        this.pid = pid;
        this.settlementNo = settlementNo;
        this.saleListItemName = saleListItemName;
        this.details = details;
        this.invoiceAmount = invoiceAmount;
        this.operator = operator;
        this.purchaser = purchaser;
        this.seller = seller;
        this.control = control;
        this.statusInfo = statusInfo;
        this.redInfo = redInfo;
        this.vehicle = vehicle;
    }

    public InvoiceInfo() {
    }

    @ApiModelProperty("校验码")
    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    @ApiModelProperty("密文")
    public String getCipherText() {
        return cipherText;
    }

    public void setCipherText(String cipherText) {
        this.cipherText = cipherText;
    }

    @ApiModelProperty("发票代码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @ApiModelProperty("开票日期(yyyyMMdd)")
    public String getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    @ApiModelProperty("开票日期时间(yyyyMMddHHmmss)")
    public String getInvoiceDateTime() {
        return invoiceDateTime;
    }

    public void setInvoiceDateTime(String invoiceDateTime) {
        this.invoiceDateTime = invoiceDateTime;
    }

    @ApiModelProperty("作废日期")
    public String getInvalidDate() {
        return invalidDate;
    }

    public void setInvalidDate(String invalidDate) {
        this.invalidDate = invalidDate;
    }

    @ApiModelProperty("发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @ApiModelProperty("发票类型(s-专票, c-普票, ju-卷票, v-机动车票, ce-电票)")
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    @ApiModelProperty("机器码")
    public String getMachineCode() {
        return machineCode;
    }

    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }

    @ApiModelProperty("是否是区块链发票")
    public String getBlockChain() {
        return blockChain;
    }

    public void setBlockChain(String blockChain) {
        this.blockChain = blockChain;
    }

    @ApiModelProperty("终端唯一码(仅4.0平台使用)")
    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }

    @ApiModelProperty("设备唯一码(仅4.0平台使用)")
    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    @ApiModelProperty("备注")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ApiModelProperty("预制发票ID")
    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @ApiModelProperty("结算单号")
    public String getSettlementNo() {
        return settlementNo;
    }

    public void setSettlementNo(String settlementNo) {
        this.settlementNo = settlementNo;
    }

    @ApiModelProperty("销货清单项目名称(返回开具请求中的入参)")
    public String getSaleListItemName() {
        return saleListItemName;
    }

    public void setSaleListItemName(String saleListItemName) {
        this.saleListItemName = saleListItemName;
    }

    @ApiModelProperty("明细")
    public List<InvoiceDetailInfo> getDetails() {
        return details;
    }

    public void setDetails(List<InvoiceDetailInfo> details) {
        this.details = details;
    }

    @ApiModelProperty("金额信息")
    public InvoiceAmountInfo getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(InvoiceAmountInfo invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    @ApiModelProperty("经办人")
    public OperatorInfo getOperator() {
        return operator;
    }

    public void setOperator(OperatorInfo operator) {
        this.operator = operator;
    }

    @ApiModelProperty("购方信息")
    public PurchaserInfo getPurchaser() {
        return purchaser;
    }

    public void setPurchaser(PurchaserInfo purchaser) {
        this.purchaser = purchaser;
    }

    @ApiModelProperty("销方信息")
    public SellerInfo getSeller() {
        return seller;
    }

    public void setSeller(SellerInfo seller) {
        this.seller = seller;
    }

    @ApiModelProperty("发票控制项")
    public ControlInfo getControl() {
        return control;
    }

    public void setControl(ControlInfo control) {
        this.control = control;
    }

    @ApiModelProperty("发票开具结果状态")
    public StatusInfo getStatusInfo() {
        return statusInfo;
    }

    public void setStatusInfo(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
    }

    @ApiModelProperty("发票红冲信息(用于开具红字发票)")
    public RedInfo getRedInfo() {
        return redInfo;
    }

    public void setRedInfo(RedInfo redInfo) {
        this.redInfo = redInfo;
    }

    @ApiModelProperty("机动车信息- 机动车发票使用")
    public VehicleInfo getVehicle() {
        return vehicle;
    }

    public void setVehicle(VehicleInfo vehicle) {
        this.vehicle = vehicle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvoiceInfo that = (InvoiceInfo) o;
        return Objects.equals(checkCode, that.checkCode) &&
                Objects.equals(cipherText, that.cipherText) &&
                Objects.equals(invoiceCode, that.invoiceCode) &&
                Objects.equals(invoiceDate, that.invoiceDate) &&
                Objects.equals(invoiceDateTime, that.invoiceDateTime) &&
                Objects.equals(invalidDate, that.invalidDate) &&
                Objects.equals(invoiceNo, that.invoiceNo) &&
                Objects.equals(invoiceType, that.invoiceType) &&
                Objects.equals(machineCode, that.machineCode) &&
                Objects.equals(blockChain, that.blockChain) &&
                Objects.equals(terminalUn, that.terminalUn) &&
                Objects.equals(deviceUn, that.deviceUn) &&
                Objects.equals(remark, that.remark) &&
                Objects.equals(pid, that.pid) &&
                Objects.equals(settlementNo, that.settlementNo) &&
                Objects.equals(saleListItemName, that.saleListItemName) &&
                Objects.equals(details, that.details) &&
                Objects.equals(invoiceAmount, that.invoiceAmount) &&
                Objects.equals(operator, that.operator) &&
                Objects.equals(purchaser, that.purchaser) &&
                Objects.equals(seller, that.seller) &&
                Objects.equals(control, that.control) &&
                Objects.equals(statusInfo, that.statusInfo) &&
                Objects.equals(redInfo, that.redInfo) &&
                Objects.equals(vehicle, that.vehicle);
    }

    @Override
    public int hashCode() {
        return Objects.hash(checkCode, cipherText, invoiceCode, invoiceDate, invoiceDateTime, invalidDate, invoiceNo, invoiceType, machineCode, blockChain, terminalUn, deviceUn, remark, pid, settlementNo, saleListItemName, details, invoiceAmount, operator, purchaser, seller, control, statusInfo, redInfo, vehicle);
    }

    @Override
    public String toString() {
        return "InvoiceInfo{" +
                "checkCode='" + checkCode + '\'' +
                ", cipherText='" + cipherText + '\'' +
                ", invoiceCode='" + invoiceCode + '\'' +
                ", invoiceDate='" + invoiceDate + '\'' +
                ", invoiceDateTime='" + invoiceDateTime + '\'' +
                ", invalidDate='" + invalidDate + '\'' +
                ", invoiceNo='" + invoiceNo + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", machineCode='" + machineCode + '\'' +
                ", blockChain='" + blockChain + '\'' +
                ", terminalUn='" + terminalUn + '\'' +
                ", deviceUn='" + deviceUn + '\'' +
                ", remark='" + remark + '\'' +
                ", pid='" + pid + '\'' +
                ", settlementNo='" + settlementNo + '\'' +
                ", saleListItemName='" + saleListItemName + '\'' +
                ", details=" + details +
                ", invoiceAmount=" + invoiceAmount +
                ", operator=" + operator +
                ", purchaser=" + purchaser +
                ", seller=" + seller +
                ", control=" + control +
                ", statusInfo=" + statusInfo +
                ", redInfo=" + redInfo +
                ", vehicle=" + vehicle +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
