package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;

@Api(value = "invoiceSales", description = "the invoiceSales API")
public interface InvoiceSalesApi {

    @ApiOperation(value = "通过明细id获取发票列表", notes = "", response = QueryInvoicesBySaleItemIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "InvoiceSales", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "返回发票列表", response = QueryInvoicesBySaleItemIdsResponse.class) })
    @RequestMapping(value = "/invoiceSales/queryInvoicesBySaleItemIds", produces = {
            "application/json" }, method = RequestMethod.POST)
    QueryInvoicesBySaleItemIdsResponse queryInvoicesBySaleItemIds(
            @ApiParam(value = "单据明细id列表参数", required = true) @RequestBody QueryInvoicesBySaleItemIdsRequest request);

    @ApiOperation(value = "通过业务单id获取发票列表", notes = "", response = QueryInvoicesBySaleItemIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "InvoiceSales", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "返回发票列表", response = QueryInvoicesBySaleItemIdsResponse.class) })
    @RequestMapping(value = "/invoiceSales/queryInvoicesByBillId", produces = {
            "application/json" }, method = RequestMethod.POST)
    QueryInvoicesBySaleItemIdsResponse queryInvoicesBySaleBillId(
            @ApiParam(value = "单据明细id列表参数", required = true) @RequestBody QueryInvoicesByBillIdRequest request);


    @ApiOperation(value = "通过发票参数获取单据明细列表", notes = "", response = QuerySaleItemIdsByInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "InvoiceSales", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "返回单据明细列表", response = QuerySaleItemIdsByInvoiceResponse.class) })
    @RequestMapping(value = "/invoiceSales/querySaleItemIdsByInvoice", produces = {
            "application/json" }, method = RequestMethod.POST)
    QuerySaleItemIdsByInvoiceResponse querySaleItemIdsByInvoice(
            @ApiParam(value = "发票查询参数", required = true) @RequestBody QuerySaleItemIdsByInvoiceRequest request);


    @ApiOperation(value = "通过发票id获取发票列表", notes = "", response = QueryInvoicesByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "InvoiceSales", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "返回发票列表", response = QueryInvoicesByIdsResponse.class) })
    @RequestMapping(value = "/invoiceSales/queryInvoicesByIds", produces = {
            "application/json" }, method = RequestMethod.POST)
    QueryInvoicesByIdsResponse queryInvoicesByIds(
            @ApiParam(value = "发票ids列表参数", required = true) @RequestBody QueryInvoicesByIdsRequest request);


    @ApiOperation(value = "通过发票号码和代码获取发票列表", notes = "", response = QueryInvoicesByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "InvoiceSales", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "返回发票列表", response = QueryInvoicesByIdsResponse.class) })
    @RequestMapping(value = "/invoiceSales/queryInvoicesByCodeAndNo", produces = {
            "application/json" }, method = RequestMethod.POST)
    QueryInvoicesByIdsResponse queryInvoicesByICodeAndNo(
            @ApiParam(value = "发票ids列表参数", required = true) @RequestBody QueryInvoicesByNoAndCodeRequest request);

    @ApiOperation(value = "获取业务单已匹配发票列表", notes = "", response = QueryInvoicesResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token") }, tags = { "InvoiceSales", })
    @ApiResponses(value = { @ApiResponse(code = 200, message = "返回发票列表", response = QueryInvoicesResponse.class) })
    @RequestMapping(value = "/invoiceSales/queryBillMatchInvoicesByPage", produces = {
            "application/json" }, method = RequestMethod.POST)
    QueryInvoicesResponse queryBillMatchInvoicesByPage(
            @ApiParam(value = "已匹配发票查询请求", required = true) @RequestBody QueryBillMatchInvoicesRequest queryBillMatchInvoicesRequest);

    @ApiOperation(value = "通过业务单匹配规则-获取待匹配发票查询", notes = "", response = SellerInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoiceByMatchRule",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SellerInvoiceQueryResponse queryInvoiceByMatchRule(@ApiParam(value = "发票查询请求") @RequestBody SellerInvoiceQueryByConditionRequest sellerInvoiceQueryByConditionRequest);
}
