package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.PreInvoiceRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 项目名称:  phoenix-seller-invoice
 * 模块名称:
 * 说明:
 * JDK 版本: JDK1.8
 *
 * @author 作者：chenqiguang
 * 创建日期：2019-02-28
 */
@Api(value = "preInvoiceToBill", description = "the preInvoiceToBill API")
public interface PreInvoiceToBillApi {

    @ApiOperation(value = "按批次号批量删除预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerPreInvoiceToBill", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/preInvoice/deleteByBatchNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response deletePreInvoiceByBatchNo(@ApiParam(value = "按批次号删除预制发票信息", required = true) @RequestBody List<Long> batchNos);

}
