package com.xforceplus.seller.invoice.client.api;


import com.xforceplus.seller.invoice.client.model.MsGetRedNoListByInvoiceRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "redNotificationDevOps", description = "运维红字信息管理api")
public interface RedNotificationDevOpsApi {

    @ApiOperation(value = "下发红字信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "RedNotificationDevOps", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/pushRedNotification",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response pushRedNotification(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoListByInvoiceRequest request);

}
