package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 作废校验接口结果
 */
@ApiModel(description = "作废校验接口结果")

@JsonInclude(NON_NULL)
public class AbandonInvoiceCheckResult {

    @ApiModelProperty(value = "校验结果 0-校验失败 1-校验成功")
    @JsonProperty("checked")
    private Integer checked;

    @ApiModelProperty(value = "释放类型系统配置 0-未配置 1-配置")
    @JsonProperty("isConfig")
    private Integer isConfig ;

    @ApiModelProperty(value = "释放类型系统配置值")
    @JsonProperty("configValue")
    private String configValue ;

    @ApiModelProperty(value = "可作废发票id列表")
    @JsonProperty("invoiceIds")
    private List<String> invoiceIds;

    @ApiModelProperty(value = "含税总金额")
    @JsonProperty("totalAmountWithTax")
    private BigDecimal totalAmountWithTax ;

    @ApiModelProperty(value = "不含税总金额")
    @JsonProperty("totalAmountWithOutTax")
    private BigDecimal totalAmountWithOutTax ;

    @ApiModelProperty(value = "总税额")
    @JsonProperty("totalTaxAmount")
    private BigDecimal totalTaxAmount ;

    @ApiModelProperty(value = "已勾选发票张数")
    @JsonProperty("selectedSheets")
    private String selectedSheets ;

    @ApiModelProperty(value = "可作废发票张数")
    @JsonProperty("canAbandonSheets")
    private String canAbandonSheets ;

    @ApiModelProperty(value = "发票校验信息列表")
    @JsonProperty("abandonInvoiceList")
    private List<AbandonInvoiceCheckInfo> abandonInvoiceList;

    public Integer getChecked() {
        return checked;
    }

    public void setChecked(Integer checked) {
        this.checked = checked;
    }

    public BigDecimal getTotalAmountWithTax() {
        return totalAmountWithTax;
    }

    public List<String> getInvoiceIds() {
        return invoiceIds;
    }

    public Integer getIsConfig() {
        return isConfig;
    }

    public void setIsConfig(Integer isConfig) {
        this.isConfig = isConfig;
    }

    public String getConfigValue() {
        return configValue;
    }

    public void setConfigValue(String configValue) {
        this.configValue = configValue;
    }

    public void setInvoiceIds(List<String> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }

    public void setTotalAmountWithTax(BigDecimal totalAmountWithTax) {
        this.totalAmountWithTax = totalAmountWithTax;
    }

    public BigDecimal getTotalAmountWithOutTax() {
        return totalAmountWithOutTax;
    }

    public void setTotalAmountWithOutTax(BigDecimal totalAmountWithOutTax) {
        this.totalAmountWithOutTax = totalAmountWithOutTax;
    }

    public BigDecimal getTotalTaxAmount() {
        return totalTaxAmount;
    }

    public void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }

    public String getSelectedSheets() {
        return selectedSheets;
    }

    public void setSelectedSheets(String selectedSheets) {
        this.selectedSheets = selectedSheets;
    }

    public String getCanAbandonSheets() {
        return canAbandonSheets;
    }

    public void setCanAbandonSheets(String canAbandonSheets) {
        this.canAbandonSheets = canAbandonSheets;
    }

    public List<AbandonInvoiceCheckInfo> getAbandonInvoiceList() {
        return abandonInvoiceList;
    }

    public void setAbandonInvoiceList(List<AbandonInvoiceCheckInfo> abandonInvoiceList) {
        this.abandonInvoiceList = abandonInvoiceList;
    }
}
