package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @author <a href="mail to: libaozhong@xforceplus.com" rel="nofollow">libaozhong</a>
 * @Description: [功能描述]
 * @version: 1.0
 * @CreateDate: 2019-08-08 13:03</p>
 */
@ApiModel(description = "红字信息申请信息")

@JsonInclude(NON_NULL)
public class InvSellerRedNotificationLogDto {

    /**
     * 单据来源1 销方 2购方

     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : user_role
     */
    private Integer userRole;

    /**
     * 申请类型1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : apply_type
     */
    private Integer applyType;

    public Integer getApplyType() {
        return applyType;
    }

    public void setApplyType(Integer applyType) {
        this.applyType = applyType;
    }

    public Integer getUserRole() {
        return userRole;
    }

    public void setUserRole(Integer userRole) {
        this.userRole = userRole;
    }


    /**
     * 票据id p票据类型为 1是发票，2 是预制发票
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : invoice_id
     */
    @ApiModelProperty(value = "票据id")
    @JsonProperty("invoiceId")
    private Long invoiceId;

    /**
     * 0.删除，1申请中，2，申请成功，3申请失
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : status
     */
    @ApiModelProperty(value = "0.删除，1申请中，2，申请成功，3申请失")
    @JsonProperty("status")
    private Integer status;

    /**
     * 红字信息表编号
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : red_notification_no
     */
    @ApiModelProperty(value = "红字信息表编号")
    @JsonProperty("redNotificationNo")
    private String redNotificationNo;

    /**
     * 票据类型，1.发票，2 预制发票
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : invoice_type
     */
    @ApiModelProperty(value = "票据类型，1.发票，2 预制发票")
    @JsonProperty("invoiceType")
    private Integer invoiceType;

    /**
     * 修改时间
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : update_time
     */
    @ApiModelProperty(value = "修改时间")
    @JsonProperty("updateTime")
    private Date updateTime;

    /**
     * c创建用户id
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : create_user_id
     */
    @ApiModelProperty(value = "c创建用户id")
    @JsonProperty("createUserId")
    private Long createUserId;

    /**
     * 更新用户id
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : update_user_id
     */
    @ApiModelProperty(value = "更新用户id")
    @JsonProperty("updateUserId")
    private Long updateUserId;

    /**
     * 设备唯一编码
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : device_un
     */
    @ApiModelProperty(value = "设备唯一编码")
    @JsonProperty("deviceUn")
    private String deviceUn;

    /**
     * 终端唯一吗
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : terminal_un
     */
    @ApiModelProperty(value = "终端唯一吗")
    @JsonProperty("terminalUn")
    private String terminalUn;

    /**
     * 1,协同 2通用
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : invoice_department
     */
    @ApiModelProperty(value = "1,协同 2通用")
    @JsonProperty("invoiceDepartment")
    private Integer invoiceDepartment;

    /**
     * 创建时间
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : create_time
     */
    @ApiModelProperty(value = "创建时间")
    @JsonProperty("createTime")
    private byte[] createTime;

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo;
    }

    public Integer getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }

    public Integer getInvoiceDepartment() {
        return invoiceDepartment;
    }

    public void setInvoiceDepartment(Integer invoiceDepartment) {
        this.invoiceDepartment = invoiceDepartment;
    }

    public byte[] getCreateTime() {
        return createTime;
    }

    public void setCreateTime(byte[] createTime) {
        this.createTime = createTime;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvSellerRedNotificationLogDto that = (InvSellerRedNotificationLogDto) o;
        return Objects.equals(userRole, that.userRole) &&
                Objects.equals(applyType, that.applyType) &&
                Objects.equals(invoiceId, that.invoiceId) &&
                Objects.equals(status, that.status) &&
                Objects.equals(redNotificationNo, that.redNotificationNo) &&
                Objects.equals(invoiceType, that.invoiceType) &&
                Objects.equals(updateTime, that.updateTime) &&
                Objects.equals(createUserId, that.createUserId) &&
                Objects.equals(updateUserId, that.updateUserId) &&
                Objects.equals(deviceUn, that.deviceUn) &&
                Objects.equals(terminalUn, that.terminalUn) &&
                Objects.equals(invoiceDepartment, that.invoiceDepartment) &&
                Arrays.equals(createTime, that.createTime);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(userRole, applyType, invoiceId, status, redNotificationNo, invoiceType, updateTime, createUserId, updateUserId, deviceUn, terminalUn, invoiceDepartment);
        result = 31 * result + Arrays.hashCode(createTime);
        return result;
    }
}
