package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * InvoiceBatchNosQueryByConditionRequest
 */

@JsonInclude(NON_NULL)
public class InvoiceBatchNosQueryByConditionRequest {
  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("userRole")
  private Integer userRole = null;

  @JsonProperty("sort")
  private Sort sort = null;

  @JsonProperty("groups")
  private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();

  @JsonIgnore
  public InvoiceBatchNosQueryByConditionRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public InvoiceBatchNosQueryByConditionRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数据量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数据量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public InvoiceBatchNosQueryByConditionRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 分类状态 (1-正常、2-待处理、0-已作废)
   * @return status
  **/
  @ApiModelProperty(value = "分类状态 (1-正常、2-待处理、0-已作废)")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public InvoiceBatchNosQueryByConditionRequest userRole(Integer userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1-销项、2-进项
   * @return userRole
  **/
  @ApiModelProperty(value = "1-销项、2-进项")
  public Integer getUserRole() {
    return userRole;
  }

  public void setUserRole(Integer userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public InvoiceBatchNosQueryByConditionRequest sort(Sort sort) {
    this.sort = sort;
    return this;
  }

   /**
   * Get sort
   * @return sort
  **/
  @ApiModelProperty(value = "")
  public Sort getSort() {
    return sort;
  }

  public void setSort(Sort sort) {
    this.sort = sort;
  }

  @JsonIgnore
  public InvoiceBatchNosQueryByConditionRequest groups(List<List<RequestField>> groups) {
    this.groups = groups;
    return this;
  }

  public InvoiceBatchNosQueryByConditionRequest addGroupsItem(List<RequestField> groupsItem) {
    this.groups.add(groupsItem);
    return this;
  }

   /**
   * 过滤器条件
   * @return groups
  **/
  @ApiModelProperty(value = "过滤器条件")
  public List<List<RequestField>> getGroups() {
    return groups;
  }

  public void setGroups(List<List<RequestField>> groups) {
    this.groups = groups;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceBatchNosQueryByConditionRequest invoiceBatchNosQueryByConditionRequest = (InvoiceBatchNosQueryByConditionRequest) o;
    return Objects.equals(this.pageNo, invoiceBatchNosQueryByConditionRequest.pageNo) &&
        Objects.equals(this.pageSize, invoiceBatchNosQueryByConditionRequest.pageSize) &&
        Objects.equals(this.status, invoiceBatchNosQueryByConditionRequest.status) &&
        Objects.equals(this.userRole, invoiceBatchNosQueryByConditionRequest.userRole) &&
        Objects.equals(this.sort, invoiceBatchNosQueryByConditionRequest.sort) &&
        Objects.equals(this.groups, invoiceBatchNosQueryByConditionRequest.groups);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageNo, pageSize, status, userRole, sort, groups);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceBatchNosQueryByConditionRequest {\n");

    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
