package com.xforceplus.seller.invoice.client.model;

import java.util.stream.Stream;

/**
 * 项目名称:
 * 模块名称:
 * 说明:          发票操作
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2018/12/1 12:40
 */
public enum InvoiceOperation {

    INVALID_OPERATION(0,"非法操作"),
    ABANDON_INVOICE(1,"作废蓝票"),
    ABANDON_RED_INVOICE(2,"作废红票"),
    ABANDON_HC_INVOICE(3, "作废红冲票"),
    HC_INVOICE(4, "红冲发票");

    private final int operationType;

    private final String operationDescription;

    InvoiceOperation(int operationType, String operationDescription){
        this.operationDescription = operationDescription;
        this.operationType = operationType;
    }

    public int value(){
        return this.operationType;
    }

    public static InvoiceOperation of(int operationType){
        return Stream.of(InvoiceOperation.values())
                .filter(item-> item.value() == operationType)
                .findFirst()
                .orElse(InvoiceOperation.INVALID_OPERATION);
    }
}
